import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import getSkinPath from "../../libs/new_wx/utils/getSkinPath";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";


export default class StartItem extends eui.ItemRenderer {
    constructor() {
        super();
        this.skinName = getSkinPath('Item');
    }

    dataChanged() {
        if (!this.hasEventListener(egret.TouchEvent.TOUCH_TAP)) {
            this.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                if ((this.data.activityStatus == 0 || this.data.activityStatus == 2)&&this.data.userStatus!=3) return;
                this.touchEnabled = false;
                this.touchChildren = false;
                setTimeout(() => {
                    if (this) {
                        this.touchEnabled = true;
                        this.touchChildren = true;
                    }
                }, 2000)
                const { data } = DataManager.ins.getData('getProjectUserInfo');
                if (this.data.sourceType == 2) {
                    NetManager.ins.yyh_light(this.data.activityId, (s, r) => {
                        if (!s) {
                            if (r.code != '101001' && r.code != '101003' && r.code != '101004') {
                                showToast('网络异常\n请隔一段时间再尝试');
                                return;
                            }
                        }
                        console.log("跳转-->>", Date.now())
                        location.href = this.data.activityUrl;
                    })
                } else {
                    location.href = this.data.activityUrl + `&esports_uid=${data.partnerUserId}`;
                }
            }, this);
        }
        this['img0'].visible = false;
        this['img2'].visible = false;
        this['img1'].visible = false;
        this['status0'].visible = false;
        this['status1'].visible = false;
        this['status2'].visible = false;
        this['status3'].visible = false;

        this[`status${this.data.userStatus}`].visible = true;
        this[`img${this.data.activityStatus}`].visible = true;

        if (this.data.userStatus == 3) {
            this[`img${this.data.activityStatus}`].visible = false;
        }

        if (this.data.activityStatus == 2 || this.data.activityStatus == 0) {
            if (this.data.userStatus != 3)
                this[`status${this.data.userStatus}`].visible = false;
        }
    }
}