import Panel from "../views/Panel";
import { DogShopItemComponent } from "../components/DogShopItemComponent";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import DogData from "../startScene/DogData";
import DataConversion from "../mainScene/DataConversion";
export default class ShopPanel extends Panel {

    public showListGroup:eui.Group;
    public foodNumLb:eui.Label;
    public panelGroup:eui.Group;
    public foodStocks:number;
    // private dogLvLists:string[];
    // private dogSizePos:any[];

    public get skinKey() { return 'ShopPanel' }
    public get groupName() { return 'shop_panel'}
    
    private callback:Function;
    constructor(data){
        super(data);
        this.foodStocks     = data;
        this.percentHeight  = 100;
    }
    
    setShowAct():void{
        this.alpha = 0;

        this.panelGroup.top = this.height;
        egret.Tween.get(this).to({alpha:1},300);

        egret.Tween.get(this.panelGroup).to({top:330}, 300, egret.Ease.cubicOut);
    }

    protected async preLoadRes(){
        

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        
        console.log('this.height',this.height)

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    public initEvents():void{
        super.initEvents();
    }

    private onTap():void{
        if(this.callback){
            this.callback();
        }
        this.hidePanel();
    }

    public removeEvents():void{
        super.removeEvents();
        //删除子项事件
        for(let i = 0; i < 30; i++){
            var item:any = this.showListGroup.getChildAt(i);
            item.removeEvent();
        }
    }

    private onLoad(): void {
        this.initData();
        this.initUI();
    }

    private initUI():void{//6b4838   515151
        let orgX = 41;
        let space = 10;
        let dataArr = DataManager.ins.shopYunjiData.data;
        for(let i = 0; i < 30; i++){
            let dname;
            let lock;
            if(!dataArr[i].lock){
                dname = 'dog_lv_' + (i + 1) + '_png';
                lock = false;
            }else{
                dname = 'dog' + i + '_png';
                lock = true;
            }
            let dItem = new DogShopItemComponent(i + 1, DogData.getNameData[i], dname, DogData.getSizeData[i], dataArr[i], this.buyBack.bind(this));
            this.showListGroup.addChild(dItem);

            dItem.x = orgX;
            dItem.y = i * (162 + space);

        }

        this.foodNumLb.text = DataConversion.doConversion(this.foodStocks);
    }

    //商店购买回调
    private buyBack(lv:number):void{
        GDispatcher.dispatchEvent("doSummon", lv);
    }

    private initData():void{}

}