"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var PanelCtrl = (function () {
    function PanelCtrl() {
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    PanelCtrl.prototype.show = function (type, data) {
        var cls = this._panelClassMap[type];
        var panel = new cls(data);
        this._current = panel;
        panel.start(data);
        // panel.y = panel.height;
        this.add(panel);
        this._parent.visible = true;
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
        panel.addEventListener('onCreditsOut', this.onCreditsOut, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        panel.removeEventListener('onCreditsOut', this.onCreditsOut, this);
        this.remove(panel);
        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    };
    PanelCtrl.prototype.onCreditsOut = function (e) {
        if (!window['CFG'] || !window['CFG'].appInfo)
            return;
        window.location.href = window['CFG'].appInfo.earnCreditsUrl;
    };
    PanelCtrl.prototype.registerPanelClass = function (name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current)
            this.remove(this._current);
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;
__reflect(PanelCtrl.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/ctrls/panelCtrl\".PanelCtrl");
//# sourceMappingURL=panelCtrl.js.map