
import Panel from "../views/Panel";
import DogData from "../startScene/DogData";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Loading from "../loading/Loading";
export default class SharePanel extends Panel {
    public panelGroup:eui.Group;
    public titleLb:eui.Label;
    public erweimaImg:eui.Image;
    public dogShadowImg:eui.Image;
    public dogImg:eui.Image;
    public closeBtn:eui.Button;
    public rectJie:eui.Rect;

    public shareBtn:eui.Button;



    private mdata:any;

    public get skinKey() { return 'Share' }
	public get groupName() { return 'share_panel'}
    constructor(data?){
        super(data);
        this.mdata = data;
    }

    start(data?):void{
        this.percentHeight = 100;
    }

    initEvents():void{
         this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
         this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }

    removeEvents():void{
         this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
         this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }



    onSkinComplete(): void {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    onTap_shareBtn():void{
        if(this.imageData){
            this.enabled=false;
            Loading.instace.show()
            NetManager.ins.imgUrl((success)=>{
                this.enabled=true;
                Loading.instace.hide()
                if(!success){
                    return
                }
                console.log(`yunji://common/saveImageToSD?img=${encodeURIComponent(DataManager.ins.getData("imgURL").data)}`)
                window.location.href = `yunji://common/saveImageToSD?img=${encodeURIComponent(DataManager.ins.getData("imgURL").data)}`
            },this.imageData)
        }
    }

    private onLoad():void{
      //  this.erweimaImg.visible = false;
        this.dogImg.source = 'dog_lv_' + (this.mdata.level) + '_png';
        this.dogImg.anchorOffsetX = DogData.getSizeData[this.mdata.level - 1][0] * 0.5;
        this.dogImg.anchorOffsetY = DogData.getSizeData[this.mdata.level - 1][1];

        this.dogImg.x = 750 * 0.5;
     //   this.dogImg.y = this.dogShadowImg.y;

        this.titleLb.text = '我在萌宠汪星球领养了' + this.mdata.dNum + '只狗狗';
        
        setTimeout(() => {
            this.scanImg();
        }, 1000);

        var ua = navigator.userAgent.toLowerCase();
        if (ua.match(/MicroMessenger/i)) {
            this.shareBtn.visible=false;
            this.erweimaImg.source="dogBg_erweima_weichat_png"
        }else{
            this.shareBtn.visible=true;
            this.erweimaImg.source="dogBg_erweima_app_png"
        }

        //img.style.display = 'none';//block
    }


    img
    imageData

    private scanImg():void{
        let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        renderTexture.drawToTexture(this.panelGroup, new egret.Rectangle(this.rectJie.x, this.rectJie.y, this.rectJie.width, this.rectJie.height));
        this.imageData = renderTexture.toDataURL("image/png");
        this.img = document.getElementById('shareImg');
        this.img.style.position = 'absolute';
        this.img['src'] = this.imageData;
        this.img.style.opacity = "0";//`${widthP}%`;
        this.img.style.width = "93.4vw";//`${widthP}%`;
        this.img.style.left  = "3.4vw";//`${leftP}%`;
        this.img.style.top   = "12.8vw";//`${topP}%`;
        this.img.style.display   = 'block';
    }

    onTap_closeBtn(){
        this.img.style.display = 'none';
        this.hidePanel();
    }
}