import { getSkinPath } from "../utils";

/**
 * 单条收支记录
 */
export default class FriendItem extends eui.Component {


    public LoadGroup:eui.Group;
    public mask_load_1:eui.Rect;
    public mask_load_2:eui.Rect;
    public load_1:eui.Image;
    public load_2:eui.Image;
    public photoGroup:eui.Group;
    public photoMask:eui.Rect;
    public photoImg:eui.Image;
    public addGroup:eui.Group;
    

    loadVal=0
    state=false;
    url

 
    constructor(data?){
        super();
        this.skinName = getSkinPath('FrendItem');
        this.touchChildren = true;
        this.init();
    }

    public init():void{
        this.load_1.mask=this.mask_load_1;
        this.load_2.mask=this.mask_load_2;
        this.photoImg.mask=this.photoMask;
    }

    setState(state){
        this.photoGroup.visible=false;
        this.addGroup.visible=false;
        this.LoadGroup.visible=false;
        this.state=state
        if(state){
            this.photoGroup.visible=true;
            this.LoadGroup.visible=true;
        }else{
            this.addGroup.visible=true;
        }
    }

    setLoadVal(loadVal){
        this.loadVal=loadVal
        if(this.loadVal==75){
            this.loadVal=75.01
        }
        if(this.loadVal<=50){
            this.load_2.rotation=180
            this.load_1.rotation=180*this.loadVal/50
        }else{
            this.load_1.rotation=180
            this.load_2.rotation=180+(180*(this.loadVal-50)/50)
        }
    }

    setImgUrl(url){
        this.url=url
        this.photoImg.source=url
    }
}