import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
export default class LevelPrizePanel extends Panel {

    public panelGroup:eui.Group;
    private prizeUrl:string;
    private level:number;
    private ptype:number;
    private pdata:any;

    public prizeImg:eui.Image;
    public prizeBtn:eui.Button;
    public lvTitleLb:eui.Label;

    public get skinKey() { return 'LevelPrizePanel' }
    public get groupName() { return 'levelPrize_panel'}
    
    private callback:Function;
    constructor(data){
        super(data);
        this.pdata = data;
        this.percentHeight  = 100;
    }
    
    setShowAct():void{
        // this.alpha = 0;

        // this.panelGroup.top = this.height;
        // egret.Tween.get(this).to({alpha:1},300);

        // egret.Tween.get(this.panelGroup).to({top:330}, 300, egret.Ease.cubicOut);
    }

    protected async preLoadRes(){
        

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        
        console.log('this.height',this.height)

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    public initEvents():void{
        super.initEvents();
        if(this.prizeImg){
            this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeImg, this);
        }

        if(this.prizeBtn){
            this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        }
    }

    private onTap():void{
        if(this.callback){
            this.callback();
        }
        this.hidePanel();
    }

    public removeEvents():void{
        super.removeEvents();
        if(this.prizeImg){
            this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeImg, this);
        }

        if(this.prizeBtn){
            this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        }
    }

    private onLoad(): void {
        this.initData();
        this.initUI();

        this.lvTitleLb.text=`狗狗等级达${this.level}级别`
    }

    private initUI():void{
        //恭喜中奖
        if(this.ptype == 0){
            this['group0'].visible = true;
            this['group1'].visible = false;

        }else{//奖品领完了
            this['group0'].visible = false;
            this['group1'].visible = true;
        }

        if(this.level > 20){
            this.prizeImg.source = 'pimg1_png';
        }else{
            this.prizeImg.source = 'pimg0_png';
        }
    }

    private onTap_prizeImg():void{
        window.location.href = this.prizeUrl;
    }

    private onTap_prizeBtn():void{
        if(this.prizeUrl){
            window.location.href = this.prizeUrl;
        }
        this.onTouchTap();
    }

    private initData():void{
        if(this.pdata){
            this.ptype = this.pdata.type;
            this.level = this.pdata.level;
        }


       // this.prizeUrl = DataManager.ins.takeBonusData.prizeLink;
       if(DataManager.ins.getData(NetName.GET_ORDER_STATUS)){
            if(DataManager.ins.getData(NetName.GET_ORDER_STATUS).lottery){
                this.prizeUrl = DataManager.ins.getData(NetName.GET_ORDER_STATUS).lottery.link;
            }
       }
       

    }

}