import ComponentBase from "../components/ComponentBase";
import Loading from "../loading/Loading";

export default class Panel extends ComponentBase {
    public pMask:egret.Shape;
    private hasMask:boolean;
    constructor(data?, hasMask:boolean = true) {
        super(data);
        this.hasMask = hasMask;
    }

    /**
     * 
     * @param hasColor true 有颜色  false为没有颜色
     */
    setMask():void{
        if(!this.pMask){
            var rate:number = document.body.clientHeight / document.body.clientWidth;
            this.pMask = new egret.Shape();
            this.pMask.graphics.beginFill(0,0.8);
            this.pMask.graphics.drawRect(0, 0, 750, 750 * rate);
            this.pMask.graphics.endFill();
            this.addChildAt(this.pMask, 0); 

            this.pMask.touchEnabled = false;
        }

    }

    setShowAct():void{
        this.alpha = 0;
        // this.y = document.body.clientHeight;
        // this.scaleY = 0;
        egret.Tween.get(this).to({alpha:1},300);
    }

    initEvents() {
        if(this.closeBtns && this.closeBtns.length > 0){
            this.closeBtns.forEach(
                btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if(this.confirmBtns && this.confirmBtns.length > 0){
            this.confirmBtns.forEach(
                btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
            this.creditsOutBtns.forEach(
                btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
            )
        }
        
    }
    removeEvents() {
        if(this.closeBtns && this.closeBtns.length > 0){
            this.closeBtns.forEach(
                btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if(this.confirmBtns && this.confirmBtns.length > 0){
            this.confirmBtns.forEach(
                btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        
        if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
            this.creditsOutBtns.forEach(
                btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
            )
        }
    }

    protected onSkinComplete() {
        super.onSkinComplete();
        Loading.instace.hide();


        this.setMask();
        if(!this.hasMask){
            this.pMask.alpha = 0;
        }

        console.log('this.pMask' + this.hasMask);

        this.setShowAct();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    protected get confirmBtns(): eui.Button[] { return [this['confirmBtn']]}
    protected get creditsOutBtns(): eui.Button[] { return [this['creditsOutBtn']] }

    onTouchTap(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }
    
    creditsOut(){
        this.destroy();
        this.dispatchEvent(new egret.Event('onCreditsOut'));
    }

}