// import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from "../../libs/tw/util/Buried";
export default class JoinPanel extends Panel {
    public closeBtn:eui.Button;
    public closeBtn0:eui.Button;
    public jlText:eui.Label;    

    public get skinKey() { return 'Join' }
    public get groupName() { return 'join_panel' }

    jlData

    constructor(data: any) {
        super(data);
        this.jlData=data;
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }
    onTouchTap(){
        super.onTouchTap()
        if(this.jlData.callBack){
            this.jlData.callBack(false);
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
         this.closeBtn0.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn0, this);
    }

    removeEvents(): void {
        super.removeEvents();
         this.closeBtn0.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn0, this);
    }

    private onTouchTap_closeBtn0():void{

        let startDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
        this.onTouchTap();
    }

    private onLoad():void{
        let startDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        this.jlText.text=this.jlData.text;
    }

    
}