
import Panel from "../views/Panel";
// import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from "../../libs/tw/manager/DataManager";
import { DogShowItemComponent } from "../components/DogShowItemComponent";
import { NetName } from "../../libs/tw/enum/NetName";
export default class DogShowPanel extends Panel {

    public showListGroup:eui.Group;
    public panelGroup:eui.Group;
    private maxLv:number;
    private dogLvLists:string[];
    private dogSizePos:any[];

    public get skinKey() { return 'DogShowPanel' }
    public get groupName() { return 'dogShow_panel'}
    
    private callback:Function;
    constructor(data){
        super(data);
        this.callback       = data;
        this.percentHeight  = 100;

        this.maxLv = DataManager.ins.getData(NetName.GET_HOME).data.maxLevel;
    }


    setShowAct():void{
        this.alpha = 0;

        this.panelGroup.top = this.height;
        egret.Tween.get(this).to({alpha:1},300);

        egret.Tween.get(this.panelGroup).to({top:330}, 300, egret.Ease.cubicOut);
    }

    protected async preLoadRes(){
        

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete():void{
        super.onSkinComplete();
        
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    public initEvents():void{
        super.initEvents();
    }

    private onTap():void{
        if(this.callback){
            this.callback();
        }
        this.hidePanel();
    }

    public removeEvents():void{
        super.removeEvents();
    }

    private onLoad(): void {
        this.initData();
        this.initUI();
    }

    private initUI():void{//6b4838   515151
        let orgX = 50;
        let spaceX = 10;
        let spaceY = 10;
        for(let i = 0; i < 30; i++){
            let dname;
            if(i < this.maxLv){
                dname = 'dog_lv_' + (i + 1) + '_png';
            }else{
                dname = 'dog' + i + '_png';
            }
            let dItem = new DogShowItemComponent(i + 1, this.dogLvLists[i], dname, this.dogSizePos[i]);
            this.showListGroup.addChild(dItem);

            let xidx = (i + 1) % 3;
            let yidx = Math.floor((i + 1) / 3) - 1;

            if(xidx > 0){
                yidx += 1;
            }

            if(xidx > 0){
                xidx -= 1;
            }else{
                xidx = 2;
            }
            dItem.x = xidx * (211 + spaceX) + orgX;
            dItem.y = yidx * (250 + spaceY);

        }
    }

    private initData():void{
        this.dogSizePos = [
            [156, 126],
            [124, 145],
            [108, 148],
            [123, 152],
            [154, 152],
            [111, 152],
            [144, 143],
            [110, 147],
            [140, 163],
            [114, 162],
            [115, 156],
            [112, 148],
            [110, 149],
            [147, 143],
            [137, 144],
            [148, 152],
            [119, 163],
            [103, 154],
            [110, 153],
            [117, 160],
            [92, 160],
            [137, 158],
            [129, 158],
            [104, 156],
            [123, 156],
            [127, 171],
            [135, 151],
            [143, 157],
            [108, 156],
            [112, 156]
        ];
        this.dogLvLists = [
            "小奶狗",
            "小白狗",
            "小黑狗",
            "小狼狗",
            "金毛",
            "柯基",
            "柴犬",
            "博美",
            "泰迪",
            "巴哥犬",
            "比熊",
            "雪纳瑞",
            "秋田犬",
            "萨摩耶",
            "贵宾犬",
            "边境牧羊犬",
            "拉布拉多",
            "哈士奇",
            "吉娃娃",
            "法国斗牛犬",
            "牛头梗",
            "蝴蝶犬",
            "杜宾",
            "松狮",
            "茶杯犬",
            "苏格兰牧羊犬",
            "英国玩具犬",
            "迦南犬",
            "阿拉斯加雪橇犬",
            "阿富汗猎犬",
        ];
    }

}