import { IShareData } from "../data/common/IShareData";

// import { IShareData } from "..";

export class Share {
    /**
     * 分享
     */
    public static doShare(sd: IShareData): void {
        switch (sd.appName) {
            case '360手机卫士':
                //360手机卫士
                this.sjws360(sd);
                break;
            case '360清理大师':
                //360清理大师
                this.clean360(sd);
                break;
            case '腾讯视频':
                //腾讯视频

                break;
            case '百度宝宝':
                //百度宝宝
                this.baiduBB(sd);
                break;
            case 'QQ阅读':
                //QQ阅读
                this.qqRead(sd);
                break;
            case 'QQ浏览器':
                //QQ浏览器
                this.qqBrowser(sd);
                break;
            case '饿了么':
                //饿了么
                this.elm(sd);
                break;
            case '书旗小说':
                //书旗小说
                this.bookChess(sd);
                break;
            case '优酷视频':
                //优酷视频
                this.youku(sd);
                break;
        }
    }

    /**
     * 360手机卫士分享
     * @param {IShareData} sd
     */
    private static sjws360(sd: IShareData) {
        if (navigator.userAgent.match(/iphone|ipod|ipad/gi)) {
            window['SESDK']['share']({
                contexts: [{
                    type: 'weibo',
                    text: sd.desc,
                    url: sd.link,
                    img: sd.imgUrl
                },
                {
                    type: 'wechat.friend.link',
                    title: sd.title,
                    desc: sd.desc,
                    thumb: sd.imgUrl,
                    url: sd.link
                },
                {
                    type: 'wechat.timeline.link',
                    title: sd.title,
                    thumb: sd.imgUrl,
                    url: sd.link
                }]
            });
        } else {
            window['MobileSafeJsInterface']['share'](JSON.stringify({
                weixin: {
                    title: sd.title,
                    desc: sd.desc,
                    link: sd.link,
                    type: "0",
                    img_url: sd.imgUrl
                },
                weibo: {
                    desc: sd.desc, //微博分享内容
                    type: "0",
                    img_url: sd.imgUrl //微博分享的长图
                }
            }));
        }
    }

    /**
     * 360清理大师分享
     * @param {IShareData} sd
     */
    private static clean360(sd: IShareData) {
        //分享前需要先初始化分享图片
        window['android']['prepareShare'](JSON.stringify({ "iconUrl": sd.imgUrl }));

        //调起分享面板
        window['android']['share'](JSON.stringify({

            content: sd.desc,
            weiboContent: sd.desc,
            weixinContent: sd.desc,
            weixinTitle: sd.title,
            shareUrl: sd.link
        }));
    }

    /**
     * 腾讯视频分享
     * @param {ShareData} sd
     */
    private static txTv(sd: IShareData) {

    }

    /**
     * 百度宝宝分享
     * @param {ShareData} sd
     */
    private static baiduBB(sd: IShareData) {
        //自定义右上角分享
        window['hybridApi']['exec']('setShare', { title: sd.title, text: sd.desc, url: sd.link, image: sd.imgUrl });
        //调起分享面板
        window['hybridApi']['exec']('share', { title: sd.title, text: sd.desc, url: sd.link, image: sd.imgUrl });
    }

    /**
     * QQ阅读分享
     * @param {ShareData} sd
     */
    private static qqRead(sd: IShareData) {
        // 1.调起分享页面
        window["Local"].shareTopic(sd.link, sd.imgUrl, sd.title, sd.desc);
        // 2.右上角“...”分享添加
        window['Local'].setIconForShareing(sd.link, sd.imgUrl, sd.title, sd.desc);
    }

    /**
     * QQ浏览器分享
     * @param {ShareData} sd
     */
    private static qqBrowser(sd: IShareData) {
        const options = {
            url: sd.link,
            title: sd.title,
            description: sd.desc,
            img_url: sd.imgUrl
        }
        window["share"](options, null);
    }

    /**
     * 汽车报价大全
     * @param {ShareData} sd
     */
    private static carPrice(sd: IShareData) {

    }

    /**
     * 饿了么分享
     * @param {ShareData} sd
     */
    private static elm(sd: IShareData) {
        window['hybridAPI']['sharePanel']({
            source: 'stage', //来源，用于统计
            targets: ['weixin', 'weixin_timeline', 'weibo', 'qq', 'qzone'], // 分享按钮
            title: sd.title,
            text: sd.desc,
            url: sd.link,
            image_url: sd.imgUrl,
            image_only: true, // 7.14 新增，分享整张图片(image_url)，只支持微信、朋友圈、QQ。
        })
    }

    /**
     * 书旗小说分享
     * @param {ShareData} sd
     */
    private static bookChess(sd: IShareData) {
        const data = {
            shareUrl: sd.link,
            shareTitle: sd.title,
            shareContent: sd.desc
        }
        window['anShuqiForSqWebJS']['openAppSendShareData'](JSON.stringify(data));
    }

    /**
     * 书旗小说分享
     * @param {ShareData} sd
     */
    private static youku(sd: IShareData) {
        window['']['setShare']({
            title: sd.title,
            link: sd.link,
            img: sd.imgUrl,
            img_only: false
        });
    }
}