"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var ComponentBase_1 = require("../components/ComponentBase");
var GuidePanel = (function (_super) {
    __extends(GuidePanel, _super);
    function GuidePanel() {
        return _super.call(this) || this;
    }
    Object.defineProperty(GuidePanel.prototype, "skinKey", {
        get: function () { return 'Guide'; },
        enumerable: true,
        configurable: true
    });
    GuidePanel.prototype.start = function (data) {
        // this.percentHeight = 100;
    };
    /**
     *
     * @param index : 当前引导的步数
     * @param x : 指引位置的x坐标
     * @param y : 指引位置的y坐标
     * @param w : 指引位置的宽度
     * @param h : 指引位置的高度
     * @param tips : 引导提示文字
     */
    GuidePanel.prototype.updateData = function (index, x, y, w, h, tips) {
        console.log('x:' + x, 'y:' + y, 'w:' + w, 'h:' + h);
        this.topMask.x = 0;
        this.topMask.y = 0;
        this.topMask.width = 750;
        this.topMask.height = y;
        this.leftMask.x = 0;
        this.leftMask.y = y;
        this.leftMask.width = x;
        this.leftMask.height = h;
        this.rightMask.x = x + w;
        this.rightMask.y = y;
        this.rightMask.width = 750 - (x + w);
        this.rightMask.height = h;
        this.bottomMask.x = 0;
        this.bottomMask.y = y + h;
        this.bottomMask.width = 750;
        this.bottomMask.height = 1624 - (y + h);
        if (this.tw1) {
            egret.Tween.removeTweens(this.tw1);
        }
        if (this.tw2) {
            egret.Tween.removeTweens(this.tw2);
        }
        this.handX = x - this.hand.width;
        this.handY = y + this.hand.height;
        this.hand.x = x - this.hand.width;
        this.hand.y = y + this.hand.height;
        this.playHand();
        this['tips'].visible = false;
        if (tips) {
            this['tips'].visible = true;
            this['txt'].text = tips;
            var tipsW = Math.min(tips.length, 14) * 32 + 100;
            if (index == 1) {
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY + 100;
            }
            else if (index == 3) {
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY + 100;
            }
            else if (index == 5) {
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY - 190;
            }
            else if (index == 8) {
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY + 100;
            }
            else if (index == 10) {
                this['tips'].x = (750 - tipsW) / 2;
                this['tips'].y = this.handY - 190;
            }
        }
    };
    /**
     * 手型缓动
     */
    GuidePanel.prototype.playHand = function () {
        this.tw1 = egret.Tween.get(this.hand).to({ x: this.handX + 30, y: this.handY - 30 }, 300).call(function () {
            this.recover();
        }, this);
    };
    /**
     * 恢复到原先位置
     */
    GuidePanel.prototype.recover = function () {
        this.tw2 = egret.Tween.get(this.hand).to({ x: this.handX, y: this.handY }, 300).call(function () {
            this.playHand();
        }, this);
    };
    GuidePanel.prototype.dispose = function () {
        if (this.tw1) {
            egret.Tween.removeTweens(this.tw1);
        }
        if (this.tw2) {
            egret.Tween.removeTweens(this.tw2);
        }
        this.hand.x = this.handX;
        this.hand.y = this.handY;
    };
    return GuidePanel;
}(ComponentBase_1.default));
exports.default = GuidePanel;
__reflect(GuidePanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/guidePanel/GuidePanel\".GuidePanel");
//# sourceMappingURL=GuidePanel.js.map