
import Panel from "../views/Panel";
import DataConversion from "../mainScene/DataConversion";
import PanelCtrl from "../ctrls/panelCtrl";
import DogData from "../startScene/DogData";
import { GTime } from "../../libs/tc/util/GTime";
import { TimeFormat } from "../../libs/tc/enum/TimeFormat";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class MsgPanel extends Panel {
    private mdata:any;

    /**
     * msg背景类型
     * 0、欢迎来到新手汪星球、狗粮不足、领取每日福利
     * 1、恭喜你 成功邀请x位好友、确认回收
     * 2、公众号每日福利 优惠券、公众号每日福利 狗粮、炫耀新宠
     */
    private bgType:number;

    /**
     * msg内容类型
     * 0、欢迎来到新手汪星球
     * 1、狗粮不足
     * 2、领取每日福利
     * 3、恭喜你 成功邀请x位好友
     * 4、确认回收
     * 5、公众号每日福利 优惠券
     * 6、公众号每日福利 狗粮
     * 7、炫耀新宠
     */
    private type:number;

    /**
     * 弹窗传值1
     */
    private val1:any;
    
    /**
    * 弹窗传值2
    */
   private val2:any;

   /**
   * 弹窗传值3
   */
  private val3:any;

    /**
     * 动效相关的传参
     */
    private actData:any;

    /**
     * 按钮回调方法
     */
    private callBack:Function;

    private orgY:number;

    public get skinKey() { return 'MsgPanel' }
    public get groupName() { return 'msg_panel'}

    constructor(data?) {
        super(data);

        this.bgType     = data.bgType;
        this.type       = data.type;
        this.val1       = data.val1;
        this.val2       = data.val2;
        this.val3       = data.val3;
        this.actData    = data.actData;
        this.callBack   = data.callBack;
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        if(this['msgBtn' + this.type]){
            this['msgBtn' + this.type].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_msgBtn, this);
        }

        this['closeBtn' + this.bgType].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this);
    }

    removeEvents():void{
        super.removeEvents();

        if(this['msgBtn' + this.type]){
            this['msgBtn' + this.type].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_msgBtn, this);
        }

        this['closeBtn' + this.bgType].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this);
    }

    private onLoad():void{
        
        this.orgY = this['bgGroup' + this.bgType].y;
        this.initMsg();
    }

    private initMsg():void{
        if(this.bgType == 3){
            this['bgGroup' + 3].visible = true;

            let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);
        }else{

            this['bgGroup' + 3].visible = false;
        }

        for(let i = 0; i < 3; i++){
            if(i == this.bgType){
                this['bgGroup' + i].visible = true;
            }else{
                this['bgGroup' + i].visible = false;
            }
        }

        for(let i = 0; i < 8; i++){
            if(i == this.type){
                this['msgGroup' + i].visible = true;
            }else{
                this['msgGroup' + i].visible = false;
            }
        }

        switch(this.type){
            case 0://欢迎来到汪星球
                let startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
                let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let exposure = Buried.createExposure(startDpmOut, startDcmOut);

                NetManager.ins.showLog(exposure);
                this["textLb0"].visible = true;
                this["textLb0"].text = ' 免费赠送你' + DataConversion.doConversion(this.val1) + '狗粮\n快用它召唤更多的汪星人吧！';
                break;
            case 1:
                startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.showLog(exposure);
                break;
            case 2:

                startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
        
                NetManager.ins.showLog(exposure);
                break;

            case 3:

                startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);

                NetManager.ins.showLog(exposure);
                this['textLb3'].text = '成功邀请好友加入了汪星人卫队\n您的狗粮迅速增加了';//'成功邀请' + this.val1 + '名好友加入汪星人卫队\n您的狗粮迅速增加了';
                break;
            case 4:
                startDpmOut = Buried.connectDpm(110, 9, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);

                NetManager.ins.showLog(exposure);
                break;
            case 6:
                startDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.showLog(exposure);

                this['textLb6'].text = DataConversion.doConversion(this.val1) + '狗粮';
                break;
            case 7:

                startDpmOut = Buried.connectDpm(110, 5, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.showLog(exposure);

                this['dogImgGroup'].removeChildren();
                let img = new eui.Image();
                img.source = 'dog_lv_' + (this.val1) + '_png';
                img.anchorOffsetX = DogData.getSizeData[this.val1 - 1][0] * 0.5;
                img.anchorOffsetY = DogData.getSizeData[this.val1 - 1][1] * 0.5;
        
                img.x = this['dogImgGroup'].width * 0.5;
                img.y = this['dogImgGroup'].height * 0.5;
        
                this['dogImgGroup'].addChild(img);
        
                this['textLb7'].text = DogData.getNameData[this.val1 - 1];
                break;
            case 8:
                let munite = Math.floor(this.val1 / 60);
                this["textLb80"].text = Math.floor(munite / 60) + '小时' + (munite % 60) + '分钟啦';
                this["textLb81"].text = '' + DataConversion.doConversion(this.val2);
                this['textLb82'].text = '最多记录离线' + Math.floor(this.val3 / 3600) + '小时';
                break;
        }
    }

    onTouchTap(): any {
        if(this.type == 0){
            this.hidePanel();
        }else{
            this.hidePanel();
        }

    }

    private onTouchTap_msgBtn():void{
        PanelCtrl.instance.btnDelay(this['msgBtn' + this.type]);
        switch(this.type){
            case 0:

                let startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
                let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.clickLog(exposure);
            break;
            case 1:

                startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
        
                NetManager.ins.clickLog(exposure);
            break;
            case 2:

                startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
            
                NetManager.ins.clickLog(exposure);
            break;
            case 3:
                startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.clickLog(exposure);
            break;
            case 4:

                startDpmOut = Buried.connectDpm(110, 9, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.clickLog(exposure);
            break;
            case 6:

                startDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
        
                NetManager.ins.clickLog(exposure);
            break;
            case 7:
                startDpmOut = Buried.connectDpm(110, 5, 1); // 点击埋点   
                startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                exposure = Buried.createExposure(startDpmOut, startDcmOut);
        
                NetManager.ins.clickLog(exposure);
            break;
        }

        if(this.bgType == 3){
            let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.clickLog(exposure);
        }
        if(this.callBack){
            this.callBack(false);
        }
        this.hidePanel();
    }

    private onTouchTap_closeBtn():void{
        PanelCtrl.instance.btnDelay(this['closeBtn' + this.bgType]);
        if(this.type == 7){
            this.pMask.alpha = 0;
            let group = this['bgGroup' + this.bgType];
            group.anchorOffsetX = 750 * 0.5;
            group.anchorOffsetY = group.height * 0.5;
            group.x = 750 * 0.5;
            group.y = this.orgY + group.height * 0.5;
    
            let endX = this.actData.x;// - group.x;
            let endY = this.actData.y;// - group.y;
            egret.Tween.get(this['bgGroup' + this.bgType]).to({x:endX, y:endY, scaleX:0.1, scaleY:0.1}, 500).call(()=>{
                if(this.callBack){
                    this.callBack(true);
                    console.log("关闭回调")
                }
                this.hidePanel();
            });
            egret.Tween.get(this['bgGroup' + this.bgType]).wait(470).to({alpha:0}, 30).call(()=>{
                if(this.callBack){
                    this.callBack(true);
                }
                this.hidePanel();
            });
        }else{
            if(this.callBack){
                this.callBack(true);
            }
            this.hidePanel();
        }
    }
}