import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import SceneCtrl from "../ctrls/sceneCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class LoadingScene extends Scene {
	public pBar:eui.ProgressBar;
	public pIconImg:eui.Image;
	public percentLb:eui.Label;
	public mainbg:eui.Image;
	private iconAct:egret.MovieClip;

	private lastVal:number;

	public get skinKey() { return 'LoadingScene' }
	public get groupName() { return 'loading_scene' }
	constructor(data?) {
		super(data);
		if (data) {
		
		}
		this.percentHeight = 100;

		this.lastVal = 0;
	}

	initEvents() {
		
		GDispatcher.addEvent('progress', this.setProgress, this);//626 117
	}

	removeEvents() {
		
		GDispatcher.removeEvent('progress', this.setProgress, this);
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();
		this.mainbg.texture = this.bgtexture;
		
		this.iconAct.anchorOffsetX = 165;
		this.iconAct.x = 115;
		this.addChild(this.iconAct);

		this.iconAct.gotoAndPlay(0, -1);
	}

	start(data?) {

	}

	protected onLoad(): void {
		this.initUI();
	}

	private initUI(): void {
		//初始化数据
		this.initData();

	}
	private initData(): void {
	}

	private setProgress(data):void{
		let v = data[0];
		let time = 450;
		this.pBar.value = v;

		// egret.Tween.get(this.iconAct).to({x:115 + 509 * v * 0.01}, time * (v - this.lastVal) * 0.01).wait(500).call(()=>{
		// 	if(v >= 100){
		// 		SceneCtrl.instance.change(ModuleTypes.START_SCENE);
		// 	}
		// });

		this.iconAct.x = 115 + 509 * v * 0.01;
		setTimeout(() => {
			if(v >= 100){
				//SceneCtrl.instance.change(ModuleTypes.START_SCENE);
				this.doMainScene()
			}
		}, 500);
		this.lastVal = v;

		this.percentLb.text = v + '%';
	}

	doMainScene(){
		if (+new Date() > 1571500800000) {
			var _img:any = document.createElement('img')
			var _div:any = document.createElement('div')
			_img.style = "width:2.81rem;"
			_img.src = '//yun.duiba.com.cn/h5/activity_custom/skins/yunji-still_190801/over.png'
			_div.style = "position:fixed;top:0;left:0;width:100%;height:100%;background-color:rgba(0,0,0,0.8);text-align:center;padding-top:1.066rem;z-index:999;"
			_div.appendChild(_img)
			document.querySelector('body').appendChild(_div)
		  }
		NetManager.ins.getHome((succuss) => {
			if (!succuss) {
				return;
			}
			this.showMainScene();
		}, this.getQueryString("dailyMark"), window["CFG"].activityId)
	}

	getQueryString(name) {
		var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
		var r = window.location.search.substr(1).match(reg);
		if (r != null) return unescape(r[2]);
		return null;
	};

	private async showMainScene(){
		await RES.loadGroup('msg_panel');
		await RES.getResAsync('msgBg0_png');
		await RES.getResAsync('msgBg1_png');
		await RES.getResAsync('msgBg2_png');
		await RES.getResAsync('msgBg3_png');
		SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
	}

	private bgtexture: egret.Texture;
	protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('lodingBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        var mcJson = await RES.getResAsync('loadingIconMc_json');
        var mcImg = await RES.getResAsync('loadingIconMc_png');
        var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

		this.iconAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
	}

	//循环播放动画
	private playAnimation(target: egret.tween.TweenGroup, isLoop: boolean = true): void {
		if (isLoop) {
			for (var key in target.items) {
				target.items[key].props = { loop: true };
			}
		}
		target.play();
    }
}