import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import AssetAdapter from "./AssetAdapter";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import Loading from "./loading/Loading";
import RulePanel from "./rulePanel/RulePanel";
import ThemeAdapter from "./ThemeAdapter";
import { ModuleTypes } from "./types/sceneTypes";
import { getResPath } from "./utils";
import layers from "./views/layers";
import MainScene from './mainScene/MainScene';
import { PetIndexData } from "../libs/tw/data/pet/PetIndexData";
import MsgPanel from "./msgPanel/MsgPanel";
import SharePanel from './sharePanel/SharePanel';
import { Buried } from '../libs/tw/util/Buried';
import LoadingScene from './loadingScene/loadingScene';
import { GDispatcher } from '../libs/tc/util/GDispatcher';
import StartScene1 from './startScene/StartScene';
import DogShowPanel from './dogShowPanel/DogShowPanel';
import ShopPanel from './shopPanel/ShopPanel';
import TeamScene from './teamScene/TeamScene';
import TopLayerCtrl from './ctrls/topLayerCtrl';
import ToastPanel from './toastPanel/ToastPanel';
import { NetName } from "../libs/tw/enum/NetName";
import JoinPanel from "./joinPanel/JoinPanel";
import Share2Panel from "./share2Panel/Share2Panel";
import LevelPrizePanel from "./levelPrizePanel/LevelPrizePanel";
import { GCache } from "../libs/tc/util/GCache";

class Main extends eui.UILayer {
    protected createChildren(): void {
        super.createChildren();
        // alert(1)
        egret.ImageLoader.crossOrigin = 'anonymous';
        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        // egret.lifecycle.onPause = () => {
        //     egret.ticker.pause();
        // }

        // egret.lifecycle.onResume = () => {
        //     egret.ticker.resume();
        // }

        //inject the custom material parser
        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        DataManager.ins.petIndexData = new PetIndexData();
        DataManager.ins.petIndexData.update(window['CFG']);

        GCache.init([window['CFG'].actId + '', window['CFG'].consumerId + '']);
        // NetManager.ins.getCredits(()=>{});

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);
        TopLayerCtrl.instance.init(layers.topLayer);
        
        Buried.init();

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        PanelCtrl.instance.registerPanelClass(ModuleTypes.MSG_PANEL, MsgPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.DOG_SHOW_PANEL, DogShowPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.SHOP_PANEL, ShopPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.SHARE_PANEL, SharePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.JOIN_PANEL, JoinPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.LEVEL_PRIZE_PANEL, LevelPrizePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.SHARE2_PANEL, Share2Panel);

        SceneCtrl.instance.registerSceneClass(ModuleTypes.LOADING_SCENE, LoadingScene);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.MAIN_SCENE, MainScene);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene1);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.TEAM_SCENE, TeamScene);


        TopLayerCtrl.instance.registerPanelClass(ModuleTypes.TOAST_PANEL, ToastPanel);

        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        // RES.loadGroup("msg", 10);
    }

    private async loadResource() {
        try {
            // const loadingView = new LoadingUI();
            // this.stage.addChild(loadingView);
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();

            // await RES.loadGroup("msg", 10);
            // this.stage.removeChild(loadingView);
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    private textfield: egret.TextField;
    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {
        //获取签到信息
        NetManager.ins.getShareCode(()=>{
            this.getGameRes();
            this.doShare()
        },window["CFG"].activityId,"hdtool")
    }

    doShare(){
        var shareData = {
            title: '飞船登陆汪星球！超多萌宠可爱来袭！',//标题
            desc: '谁家汪更可爱？',//描述
            link: `${window["shareData"].link}&ShareCode=${DataManager.ins.getData(NetName.GET_SHARECODE).shareCode}`,//链接
            imgUrl: 'https://yun.duiba.com.cn/db_games/activity/yjyc/share.jpg',//图片
        }
        window["invokeWX"](shareData)
    }

    //加载游戏中的资源
    private async getGameRes(){
        //还没有宠物，先播放介绍文字
        // if (!DataManager.ins.petHomeInfoData.petId) {
        //     await RES.loadGroup('adopte_panel');
        //    // await RES.getResAsync('adopteBg_jpg');
        //     PanelCtrl.instance.show(ModuleTypes.ADOPTE_PANEL);
        //     await RES.loadGroup('guide_component');
        // } else {//已经有宠物了，进入游戏场景
        //     await RES.loadGroup('main_scene');
        //    // await RES.getResAsync('bgday_jpg');
        //     SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
        // }

        try{
            await RES.loadGroup('loading_scene');
            await RES.getResAsync('lodingBg_jpg');
            await RES.getResAsync('loadingIconMc_json');
            await RES.getResAsync('loadingIconMc_png');
            SceneCtrl.instance.change(ModuleTypes.LOADING_SCENE);
        }catch(err){
           console.log('err', err);
           SceneCtrl.instance.change(ModuleTypes.LOADING_SCENE);
        }
        
        try{
            GDispatcher.dispatchEvent('progress',[5]);
            await RES.loadGroup('common');
            await RES.getResAsync('startBg_jpg');
            GDispatcher.dispatchEvent('progress',[10]);
            await RES.loadGroup('start_scene');
            GDispatcher.dispatchEvent('progress',[15]);
            await RES.loadGroup('dog_component');
            GDispatcher.dispatchEvent('progress',[35]);
            await RES.getResAsync('main_star_an_json');
            await RES.getResAsync('main_star_an_png');
            GDispatcher.dispatchEvent('progress',[65]);
            await RES.loadGroup('main_scene');
            GDispatcher.dispatchEvent('progress',[85]);
            await RES.getResAsync('main_Bg_jpg');
            GDispatcher.dispatchEvent('progress',[100]);
        }catch(err){
            console.log('err1', err);
            GDispatcher.dispatchEvent('progress',[100]);
        }

        //延时加载
        await RES.loadGroup('msg_panel');
        await RES.getResAsync('msgBg0_png');
        await RES.getResAsync('msgBg1_png');
        await RES.getResAsync('msgBg2_png');
        await RES.getResAsync('msgBg3_png');
        await RES.loadGroup('levelPrize_panel');

        // await RES.getResAsync('dShowBg_png');
        await RES.loadGroup('dogShow_panel');
        await RES.loadGroup('shop_panel');

        await RES.getResAsync('team_bg_jpg');
        await RES.loadGroup('team_scene');

        await RES.getResAsync('shareBg_jpg');
        await RES.loadGroup('share_panel');

        




        //加载组
        // await RES.loadGroup('signIn_prize_panel');
        // await RES.loadGroup('signIn_panel');
        // await RES.loadGroup('extra_prize_panel');
        // await RES.loadGroup('upPrize_panel');
        // await RES.loadGroup('upNoPrize_panel');
        // await RES.loadGroup('earnGold_panel');
        // await RES.loadGroup('guide_panel');
        // //加载图片
        // await RES.getResAsync('gamerule_jpg');
        // await RES.getResAsync('guideBg_jpg');

    }
}

window['Main'] = Main;