import { INetData } from './../interface/INetData';
import { GTime } from "../util/GTime";
import { GConsole } from "../util/GConsole";
import { IData } from '../interface/IData';
export abstract class ABNetManager {
    /**
     * 接口底层错误
     */
    public static ERROR = 'Error';

    /**
     * 调用接口对象池
     */
    private callbackPool: any = {};

    constructor() {
    }

    /**
     * 发送请求
     * @param net 
     */
    public send(net: INetData): void {
        let gTime: string = '?_=' + GTime.getTimestamp();
        let realUrl: string = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime.getTimestamp();
        }

        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }

        
        let obj={
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            success: (result) => {
                this.onResponse(net, result);
            },
            error: (message) => {
                this.onError(net,message);
            }
        }
        if(net.name=="imgURL"){
            obj["headers"] = {
                "Content-Type": "application/json",
                'Authorization': 'my-auth-token'
            }
        }
        window['$'].ajax(obj);
    }

    /**
     * 消息响应
     * @param net 
     */
    protected abstract onResponse(net: INetData, result: IData): void 

    /**
     * 通讯底层错误
     * @param net 
     * @param message 
     */
    protected abstract onError(net: INetData, message?: any): void 
}