import Loading from "../../libs/new_wx/components/Loading";
import Panel from "../../libs/new_wx/components/Panel";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";
import isMPBank from "../isMPBank";
import { getlogItem } from "../LoadingScene";
import TaskItemRenderer from "./TaskItemRenderer";
import getShareIMG from "../getShareIMG";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import wait from "../../libs/new_tc/wait";


export default class TaskPanel extends Panel {
    list; wxBtn; pyqBtn;
    start() {
        super.start();
        NetManager.ins.showLog(getlogItem(21));

        // NetManager.ins.showLog(getlogItem(22));
        // NetManager.ins.showLog(getlogItem(23));
        // NetManager.ins.showLog(getlogItem(24));
        // NetManager.ins.showLog(getlogItem(25));
        // NetManager.ins.showLog(getlogItem(26));
        // NetManager.ins.showLog(getlogItem(27));
        // NetManager.ins.showLog(getlogItem(38));
        // NetManager.ins.showLog(getlogItem(39));

        // this['avatar'].mask = this['avatarMask'];
        // this['avatar'].source='https://yun.duiba.com.cn/db_games/yyhlogo.png';

        this.list.useVirtualLayout = false;
        this.list.itemRenderer = TaskItemRenderer;

        this.once(egret.Event.ADDED_TO_STAGE, () => {
            this.height = this.stage.stageHeight;
        }, this);

        this.wxBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_wxBtn, this);
        this.pyqBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_pyqBtn, this);

        NetManager.ins.yyh_taskInfo(() => {
            const tasks: any[] = DataManager.ins.getData('yyh_taskInfo').data.tasks;
            const dailyTasks = tasks.filter(task => task.type == 0);
            const dailyTask = dailyTasks[0];
            const monthlyTasks = tasks.filter(task => task.type == 1);
            this.list.dataProvider = new eui.ArrayCollection(monthlyTasks);

            this['dailyTitle'].text = '分享任务';
            // this['dailyTitle'].text = dailyTask.id;
            this['awardTxt'].text = `+4`;
            this['completeBtn'].visible = dailyTask.status == 1;
            this['gobtn'].visible = dailyTask.status == 0;


            this['completeBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, (e: egret.Event) => {
                showToast('今日已完成，分享不再获得额外松果');
                NetManager.ins.clickLog(getlogItem(21));
                wait(500).then(() => {
                    this.showshare();
                });
            });
            this['gobtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, (e: egret.Event) => {
                e.stopPropagation();
                NetManager.ins.clickLog(getlogItem(21));
                NetManager.ins.yyh_doTask(() => { }, dailyTask.id);
                this.showshare();
            }, this);
        });
    }

    private showshare() {
        if (isMPBank()) {
            this['inShareGroup'].visible = true;
            this['inShareCloser'].visible = true;
            egret.Tween.get(this['inShareGroup']).set({ bottom: -500 }).to({ bottom: 0 }, 200);
            this.stage.once(egret.TouchEvent.TOUCH_TAP, () => {
                egret.Tween.get(this['inShareGroup']).to({ bottom: -800 }, 200).call(() => {
                    this['inShareGroup'].visible = false;
                    this['inShareCloser'].visible = false;
                    this.touchEnabled = true;
                    this.touchChildren = true;
                });
            }, this);
        }
        else {
        }
    }

    onTap_wxBtn() {
        this.touchEnabled = false;
        this.touchChildren = false;
        Loading.instace.show();
        setTimeout(() => {
            Loading.instace.hide();
            this['completeBtn'].visible = true;
            this['gobtn'].visible = false;
        }, 2000);

        let sharetype = 'weixinsession'
        let url = window['shareLink'];
        let title = encodeURIComponent("做任务得松果，超值好礼待你拿～");
        let text = encodeURIComponent("一起领养小松鼠，换购丰富好礼吧！");
        let cmd = 'http://cmbls/socialshare?id=ZPsocialshare&channel=' + sharetype + '&type=url&title=' + title + '&text=' + text + '&url=' + encodeURIComponent(url);
        setTimeout(() => {
            this.cmblsJSExecutor(cmd);
        }, 500)

        window['CMBLS'].socialShare.successCallback = (id, message) => {


        };
        window['CMBLS'].socialShare.failCallback = (id, message) => {


        };
    }

    onTap_pyqBtn() {
        this.touchEnabled = false;
        this.touchChildren = false;
        Loading.instace.show();
        setTimeout(() => {
            Loading.instace.hide();
            this['completeBtn'].visible = true;
            this['gobtn'].visible = false;
        }, 2000);

        // 朋友圈
        // 朋友圈
        let sharetype = 'weixintimeline'
        // let sharePosterImg = encodeURIComponent(this.shareIMG);
        let url = window['shareLink'];
        let title = encodeURIComponent("做任务得松果，超值好礼待你拿～");
        let text = encodeURIComponent("一起领养小松鼠，换购丰富好礼吧！");
        let cmd = 'http://cmbls/socialshare?id=ZPsocialshare&channel=' + sharetype + '&type=url&title=' + title + '&text=' + text + '&url=' + encodeURIComponent(url);
        console.log(cmd);
        setTimeout(() => {
            this.cmblsJSExecutor(cmd);
        }, 500)

        window['CMBLS'].socialShare.successCallback = (id, message) => {
        };
        window['CMBLS'].socialShare.failCallback = (id, message) => {
        };
    }

    private cmblsJSExecutor(cmblsCommand) {
        const self = this;
        if (window['cmblsExecutor']) {
            var cmblsExecutor = window['cmblsExecutor'] || {};
            window['cmblsExecutor'].executeCmbls("1.0", cmblsCommand);

        } else {
            document.addEventListener('CMBLSExecutorReady', () => {
                var cmblsExecutor = window['cmblsExecutor'] || {};
                window['cmblsExecutor'].executeCmbls("1.0", cmblsCommand);
            }, false);
        }
    };

    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['closeBtn2']] }

    get skinKey() { return 'Task' }
}