import Panel from "../../libs/new_wx/components/Panel";
import getPrize from "../getPrize";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../LoadingScene";

export default class Sign7Panel extends Panel {
    start({id}) {
        super.start();
        const dosign = DataManager.ins.getData('yyh_dosign').data;
        this['title'].text = `连续签到7天`;
        this['nums'].text = `x${getPrize(id)}`;
        NetManager.ins.showLog(getlogItem(18));
    }

    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        NetManager.ins.clickLog(getlogItem(18));
    }

    
    protected get closeBtns(): eui.Button[] { return [this['closeBtn'],this['closeBtn2']] }
    
    get skinKey() { return 'Sign7' }
    get resKey() { return 'sign' }
}