import Panel from "../../libs/new_wx/components/Panel";
import getPrize from "../getPrize";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../LoadingScene";

export default class Sign1Panel extends Panel {
    start({ id }) {
        super.start();
        const dosign = DataManager.ins.getData('yyh_dosign').data;
        this['title'].text = `连续签到${dosign.continueDay}天`;
        this['day'].text = `${dosign.breakDays}`;
        this['nums'].text = `x${getPrize(id)}`;

        // setInterval(()=>{console.log(this['day'].textWidth)},1000)
        this['break'].visible = dosign.breakDays > 0;
        // this['notBreak'].visible = dosign.breakDays <= 0;

        if (dosign.breakDays <= 0)
            this['closeBtn2'].y = 702;
            
        this.once(egret.Event.RENDER, () => {
            this['prefix'].x = this['day'].x + this['day'].textWidth * 0.75;
        }, this);

        NetManager.ins.showLog(getlogItem(17));
    }

    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        NetManager.ins.clickLog(getlogItem(17));
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['closeBtn2']] }

    get skinKey() { return 'Sign1' }
    get resKey() { return 'sign' }
}