import Panel from "../../libs/new_wx/components/Panel";
import { HtmlTextParser } from "../../libs/new_wx/HtmlTextParser";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../LoadingScene";


export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        super.start();
        NetManager.ins.showLog(getlogItem(28));
        NetManager.ins.yyh_queryProjectRule((success) => {
            let str: string = DataManager.ins.getData('yyh_queryProjectRule').data;
            while (str.indexOf('<p>') != -1) {
                str = str.replace('<p>', '');
            }
            while (str.indexOf('</p>') != -1) {
                str = str.replace('</p>', '<br>');
            }
            this.addRule('<br>' + str);
        });
    }
    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        NetManager.ins.clickLog(getlogItem(28));
    }
    group: eui.Group;
    private addRule(str) {
        const text = str;
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }
    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['closeBtn2']] }

    get skinKey() { return 'Rule' }
    get resKey() { return 'rule' }
}