import Panel from "../../libs/new_wx/components/Panel";
import getPrize from "../getPrize";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../LoadingScene";


export default class QAFailPanel extends Panel {
    list;
    start(data) {
        super.start();
        this['tips'].text = `啊哦！\n好遗憾送你${getPrize(data.prizeId)}颗松果`;
        this['okbtn'].visible = !data.next;
        this['nextbtn'].visible = data.next;

        if(data.next) //下一题
        {
            NetManager.ins.showLog(getlogItem(33));
        }else {
            NetManager.ins.showLog(getlogItem(34));

        }

        this['okbtn'].once(egret.TouchEvent.TOUCH_TAP, () => {
            SceneCtrl.instance.change('MainScene');
            NetManager.ins.yyh_questionInfo(() => { });
            this.hidePanel(false);
            NetManager.ins.clickLog(getlogItem(34));
        }, this);

        this['nextbtn'].once(egret.TouchEvent.TOUCH_TAP, () => {
            this.hidePanel(false,'next');
            NetManager.ins.clickLog(getlogItem(33));
        }, this);
    }

    
    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    
    get skinKey() { return 'QAFail' }
    get resKey() { return 'qa' }
    

}