const parser = new SVGA.Parser();
export const loadSvga = (url: string, parent?: egret.DisplayObjectContainer) => {
    return new Promise((resolve, reject) => {

        parser.load(url, (videoItem) => {
            const mv = new SVGA.EgretMovieClip(videoItem);
            
            if (parent) {
                mv.gotoAndPlay(1, true)
                parent.addChild(mv);
            }

            mv.addEventListener(egret.Event.COMPLETE, () => {
                // console.log("播放完成")
            }, this);

            resolve(mv);

        }, (error) => {
            reject(error.message);
        })
    });
}

export const loadSvgaRes = (url: string) => {
    return new Promise((resolve, reject) => {
        parser.load(url, (videoItem) => {
            resolve();
        }, (error) => {
            reject(error.message);
        })
    });
}