import getResPath from "../libs/new_tc/getResPath";
import wait from "../libs/new_tc/wait";
import Scene from "../libs/new_wx/components/Scene";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { loadSvga } from "./loadSvga";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import { NetManager } from "../libs/tw/manager/NetManager";
import { getlogItem } from "./LoadingScene";
const iswx =  () => {
    return navigator.userAgent.toLowerCase().indexOf('micromessenger') !== -1
}

export default class StartScene extends Scene {

    async start(d?) {

        this.showlog();
        this['btn'].alpha = 0;
        this['tips'].scaleX = this['tips'].scaleY = 0;
        this['tips'].x = 320; this['tips'].y = 550;

        const title = await loadSvga(getResPath() + 'resource/assets/svgas/title.svga', this) as SVGA.EgretMovieClip;
        title.y = -100;
        title.once(egret.Event.COMPLETE, () => {
            title.stop();
            wait(800).then(() => {
                egret.Tween.get(this['tips']).to({ scaleX: 1, scaleY: 1 }, 200, egret.Ease.getBackOut(2));
            });
        }, this);

        const jump = await loadSvga(getResPath() + 'resource/assets/svgas/standby.svga', this) as SVGA.EgretMovieClip;
        jump.x = -40; jump.y = 70;

        const btn = await loadSvga(getResPath() + 'resource/assets/svgas/btn.svga', this) as SVGA.EgretMovieClip;
        btn.x = 60; btn.y = 850;
        this.addChild(this['tips']);
        this.addChild(this['btn']);
        this.addChild(this['shareLayer']);

        this['btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            if (window['isInvitePage'] == 1) {
                if(iswx()) {
                    this['shareLayer'].visible=true;
                    this['shareLayer'].once(egret.TouchEvent.TOUCH_TAP, () => {
                        this['shareLayer'].visible=false;
                    },this);
                }
                else {
                    window.location.href = window['applink']
                }
            }
            else {
                NetManager.ins.clickLog(getlogItem(1));
                SceneCtrl.instance.change('MainScene', { fromStart: 1 });
            }
        }, this);
    }



    get skinKey() { return 'Start' }

    showlog() {
        NetManager.ins.showLog(getlogItem(1));
    }
}
