import Scene from "../libs/new_wx/components/Scene";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import QAItem2 from "./QAItem2";

export default class QAScene2 extends Scene {
    a: QAItem2;
    b: QAItem2;
    select: QAItem2;
    _currentIndex;
    async start(d?) {
        this.a = new QAItem2();
        this.b = new QAItem2();
        this.a.x = 70;
        this.b.x = 70;
        this.a.y = 509;
        this.b.y = 711;
        this.addChild(this.a);
        this.addChild(this.b);

        this['confirmbtn'].visible = false;


        this['leaveBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_leave, this);
        this['nextbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_next, this);

        this['tipsbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, (e: egret.Event) => {
            this['tipsGroup'].visible = !this['tipsGroup'].visible;
            e.stopPropagation();
            this.stage.once(egret.TouchEvent.TOUCH_TAP, () => {
                this['tipsGroup'].visible = false;
            }, this);
        }, this);

        const questions = this.getQuestions();
        const i = 0;
        const order = i + 1;
        const question = questions[i];
        this._currentIndex = i;
        this['progress'].text = `${order}/${questions.length}`;
        this['question'].text = question.content;
        this.reset(question.answers, question.prompt, question.correctAnswer,question.userAnswer);

        this.showNextBtn();
    }

    ontap_leave() {
        SceneCtrl.instance.change('MainScene');
    }

    ontap_next() {
        this.nextQuestion();
        if (!this.checkNextQuestion()) {
            this['leaveBtn'].visible = true;
            this['nextbtn'].visible = false;
        }
    }


    showNextBtn() {
        this['leaveBtn'].visible = false;
        this['nextbtn'].visible = true;
    }

    checkNextQuestion() {
        return (this._currentIndex + 1) < this.getQuestions().length;
    }

    nextQuestion() {
        this._currentIndex++;
        const question = this.getQuestions()[this._currentIndex];
        const order = this._currentIndex + 1;
        this['progress'].text = `${order}/${this.getQuestions().length}`;
        this['question'].text = question.content;
        this.reset(question.answers, question.prompt, question.correctAnswer, question.userAnswer);
    }

    getQuestions(): any[] {
        return DataManager.ins.getData('yyh_questionInfo').data.questions;
    }

    reset([a, b], prompt, correctAnswer, userAnswer) {
        this.select = null;
        if (correctAnswer == 0) {
            if (userAnswer == correctAnswer) {
                this.a.resetData('A', a, 1);
                this.b.resetData('B', b, null);
            } else {
                this.a.resetData('A', a, null);
                this.b.resetData('B', b, 0);
            }

        } else {
            if (userAnswer == correctAnswer) {
                this.a.resetData('A', a, null);
                this.b.resetData('B', b, 1);
            } else {
                this.a.resetData('A', a, 0);
                this.b.resetData('B', b, null);
            }
        }

        this['tipsContent'].text = prompt;
        this['tips'].height = this['tipsContent'].textHeight + 30;
        this['tipsGroup'].visible = false;
    }

    get skinKey() { return 'QA' }

    showlog() { }
}