import Scene from "../libs/new_wx/components/Scene";
import { DataManager } from "../libs/tw/manager/DataManager";
import QAItem from "./QAItem";
import wait from "../libs/new_tc/wait";
import { NetManager } from "../libs/tw/manager/NetManager";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import Panel from "../libs/new_wx/components/Panel";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import Loading from "../libs/new_wx/components/Loading";
import { showToast } from "../libs/new_wx/ctrls/toastCtrl";
import { getlogItem } from "./LoadingScene";

export default class QAScene extends Scene {

    a: QAItem;
    b: QAItem;
    select: QAItem;
    _currentIndex;
    async start(d?) {
        // PanelCtrl.instance.show('QASuccessPanel');


        this.a = new QAItem();
        this.b = new QAItem();
        this.a.x = 70;
        this.b.x = 70;
        this.a.y = 509;
        this.b.y = 711;
        this.addChild(this.a);
        this.addChild(this.b);

        NetManager.ins.showLog(getlogItem(29));

        this.a.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_a, this);
        this.b.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_b, this);
        this['confirmbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_confirmbtn, this);
        this['leaveBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_leave, this);
        this['nextbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_next, this);

        this['tipsbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, (e: egret.Event) => {
            NetManager.ins.clickLog(getlogItem(29));
            this['tipsGroup'].visible = !this['tipsGroup'].visible;
            e.stopPropagation();
            this.stage.once(egret.TouchEvent.TOUCH_TAP, () => {
                this['tipsGroup'].visible = false;
            }, this);
        }, this);

        let i;
        const questions: any[] = this.getQuestions();
        for (i = 0; i < questions.length; i++) {
            const question = questions[i];
            if (question.userAnswer === null)
                break;
        }
        const order = i + 1;
        const question = questions[i];
        this._currentIndex = i;
        this['progress'].text = `${order}/${questions.length}`;
        this['question'].text = question.content;
        this.a.x = -750;
        this.b.x = 750;
        this['confirmbtn'].enabled = false;
        await wait(500);
        this.reset(question.answers, question.prompt);
    }

    ontap_leave() {
        NetManager.ins.yyh_questionInfo(() => { });
        SceneCtrl.instance.change('MainScene');
        NetManager.ins.clickLog(getlogItem(36));
    }

    ontap_next() {
        NetManager.ins.clickLog(getlogItem(35));
        this.nextQuestion();
    }

    ontap_confirmbtn() {
        if (!this.select) return;
        NetManager.ins.clickLog(getlogItem(30));
        const q = this.getQuestions()[this._currentIndex];
        this['confirmbtn'].touchEnabled = false;
        this.a.touchEnabled=false;
        this.b.touchEnabled=false;
        this.a.touchChildren=false;
        this.b.touchChildren=false;
        Loading.instace.show();
        NetManager.ins.yyh_doAnswer(async (s) => {
            Loading.instace.hide();
            if (s) {
                this['confirmbtn'].touchEnabled = false;
                const data = DataManager.ins.getData('yyh_doAnswer').data;
                if (data.correct) {
                    this.select.setCorrect();
                    await wait(500);
                } else {
                    this.select.setInCorrect();
                    await wait(100);
                    const stren = 15; const dur = 1000 / 40;
                    egret.Tween.get(this)
                        .to({ x: 10 }, dur).to({ x: 0 }, dur).to({ x: -10 }, dur).to({ x: 0 }, dur).to({ x: 10 }, dur).to({ x: 0 }, dur).to({ x: -10 }, dur).to({ x: 0 }, dur)
                        .to({ x: 10 }, dur).to({ x: 0 }, dur).to({ x: -10 }, dur).to({ x: 0 }, dur).to({ x: 10 }, dur).to({ x: 0 }, dur).to({ x: -10 }, dur).to({ x: 0 }, dur);
                    await wait(700);
                }
                const next = this.checkNextQuestion();
                let panel: Panel;
                if (data.correct) {
                    panel = PanelCtrl.instance.show('QASuccessPanel', { next: next, prizeId: data.prizeId });
                } else {
                    panel = PanelCtrl.instance.show('QAFailPanel', { next: next, prizeId: data.prizeId });
                }
                panel.once('onDestroy', (e: egret.Event) => {
                    if (next) {
                        const fromNextBtn = e.data.extra == 'next';
                        this['confirmbtn'].touchEnabled = true;
                        if (fromNextBtn)
                            this.nextQuestion();
                        else
                            this.showNextBtn();
                            NetManager.ins.showLog(getlogItem(35));
                    } else {
                        this.gameover();
                    }
                }, this);
            } else {
                showToast('网络异常\n请隔一段时间再尝试');
                this['confirmbtn'].touchEnabled = true;
            }
        }, q.id, this.select.answerIndex);
    }

    gameover() {
        NetManager.ins.showLog(getlogItem(36));
        this['leaveBtn'].visible = true;
        this['nextbtn'].visible = false;
        this['confirmbtn'].visible = false;
    }

    showNextBtn() {
        this['leaveBtn'].visible = false;
        this['nextbtn'].visible = true;
        this['confirmbtn'].visible = false;
    }

    checkNextQuestion() {
        return (this._currentIndex + 1) < this.getQuestions().length;
    }

    nextQuestion() {
        this._currentIndex++;
        const question = this.getQuestions()[this._currentIndex];
        const order = this._currentIndex + 1;
        this['progress'].text = `${order}/${this.getQuestions().length}`;
        this['question'].text = question.content;
        this.reset(question.answers, question.prompt);
    }

    getQuestions(): any[] {
        return DataManager.ins.getData('yyh_questionInfo').data.questions;
    }

    updateBtn() {
        this['confirmbtn'].enabled = true;
    }

    ontap_a() {
        this.a.selected = true;
        this.b.selected = false;
        this.select = this.a;
        this.updateBtn();
    }

    ontap_b() {
        this.a.selected = false;
        this.b.selected = true;
        this.select = this.b;
        this.updateBtn();
    }

    reset([a, b], prompt) {
        this.select = null;
        egret.Tween.get(this.a).set({ x: -750 }).to({ x: 70 }, 300);
        egret.Tween.get(this.b).set({ x: 750 }).to({ x: 70 }, 300);
        this.a.resetData('A', a, 0);
        this.b.resetData('B', b, 1);
        this['tipsContent'].text = prompt;
        this['tips'].height = this['tipsContent'].textHeight + 30;
        this['tipsGroup'].visible = false;
        this['confirmbtn'].enabled = false;
        this['leaveBtn'].visible = false;
        this['nextbtn'].visible = false;
        this['confirmbtn'].visible = true;
        NetManager.ins.showLog(getlogItem(30));
        this.a.touchEnabled=true;
        this.b.touchEnabled=true;
        this.a.touchChildren=true;
        this.b.touchChildren=true;
    }

    get skinKey() { return 'QA' }

    showlog() { }
}