import ComponentBase from "../libs/new_wx/components/ComponentBase";
import getSkinPath from "../libs/new_wx/utils/getSkinPath";

export default class QAItem2 extends ComponentBase {
    constructor() {
        super();

        this.skinName = getSkinPath('QAItem');
    }

    resetData(order, answer, isCorrect) {
        this['error'].visible = false;
        this['correct'].visible = false;
        this['select'].visible = false;
        this['bg'].visible = false;

        if (isCorrect === null)
            this['bg'].visible = true;
        else {
            this['error'].visible = !isCorrect;
            this['correct'].visible = isCorrect;
        }

        this['order'].source = `qa_icon_${order}_png`;
        this['answertxt'].text = answer;
    }
}