import ComponentBase from "../libs/new_wx/components/ComponentBase";
import getSkinPath from "../libs/new_wx/utils/getSkinPath";

export default class QAItem extends ComponentBase {
    constructor() {
        super();

        this.skinName = getSkinPath('QAItem');
    }

    answerIndex;
    resetData(order, answer, answerIndex) {
        this.answerIndex=answerIndex;
        this['error'].visible = false;
        this['correct'].visible = false;
        this['select'].visible = false;
        this['bg'].visible = true;
        this['order'].source = `qa_icon_${order}_png`;
        this['answertxt'].text = answer;

        this.selected=false;
    }

    setCorrect(){
        this['error'].visible = false;
        this['correct'].visible = true;
        this['select'].visible = false;
        this['bg'].visible = false;
    }
    setInCorrect(){
        this['error'].visible = true;
        this['correct'].visible = false;
        this['select'].visible = false;
        this['bg'].visible = false;
    }

    _select;
    get selected (){return this._select}
    set selected(val) {
        this._select=val;
        if (val) {
            this['select'].visible = true;
            this['bg'].visible = false;
        } else {
            this['select'].visible = false;
            this['bg'].visible = true;
        }

    }
}