import Scene from "../libs/new_wx/components/Scene";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import MoneyItemRenderer from "./MoneyItemRenderer";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";

export default class MoneyScene extends Scene {
    private list: eui.List;
    backbtn;
    async start(d?) {
        const userInfo = DataManager.ins.getData('getProjectUserInfo').data;
        this['nums'].text = userInfo.consumerCredits;

        this.list.useVirtualLayout = true;
        this.list.itemRenderer = MoneyItemRenderer;

        this.backbtn.once(egret.TouchEvent.TOUCH_TAP, () => {
            SceneCtrl.instance.change('MainScene');
        }, this);

        NetManager.ins.yyh_weOrder(() => {
            const list = DataManager.ins.getData('yyh_weOrder').data.list;
            this.list.dataProvider = new eui.ArrayCollection(list);
        });

    }

    get skinKey() { return 'Money' }
    get resKey() { return 'noname' }

    showlog() { }
}