import getSkinPath from "../libs/new_wx/utils/getSkinPath";

const getOrigin = (credit) => {
    switch (credit) {
        case 2:
            return '签到';
        case 12:
            return '第7天签到';
        case 4:
            return '分享任务';
        case 5:
            return '其他任务';
        case 1:
            return '答题错误';
        case 3:
            return '答题正确';

    }
    return '商品兑换';
}
export default class MoneyItemRenderer extends eui.ItemRenderer {
    constructor() {
        super();
        this.skinName = getSkinPath('MoneyItem');
    }

    dataChanged() {
        const { gmtCreate, credits, bizType } = this.data;
        console.log(this.data)
        if (bizType == "consume") {
            this['numstxt'].text = '-' + credits;
            this['nametxt'].text = "商品兑换";
        } else {
            this['numstxt'].text = '+' + credits;
            this['nametxt'].text = getOrigin(credits);
        }

        this['datextxt'].text = new Date(gmtCreate).toLocaleDateString();
    }
}