import { Buried } from './../libs/tw/util/Buried';
import getResPath from "../libs/new_tc/getResPath";
import Scene from "../libs/new_wx/components/Scene";
import { loadSvga } from "./loadSvga";
import ExchangeItemRenderer from "./ExchangeItemRenderer";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import { showToast } from "../libs/new_wx/ctrls/toastCtrl";
import { getGuideBg1, getGuideBg2, getGuideBg3, getGuideBg4, getGuideBg5 } from "./GuideBg";
import { getlogItem } from "./LoadingScene";
import { TwFun } from "../libs/tw/util/TwFun";
import wait from "../libs/new_tc/wait";

export default class MainScene extends Scene {
    scroll: eui.Scroller;
    jump: SVGA.EgretMovieClip;
    standby: SVGA.EgretMovieClip;
    kiss: SVGA.EgretMovieClip;

    private currentAction: string;

    private sv;

    private STEP_MAX = 5;
    async start(d?) {
        super.start();
        this.showlog();
        this.updateCredits();
        let guide = d && d.fromStart;
        this.scroll.height = this.stage.stageHeight;

        let groupHeight = 1624 + 200;//默认是1624，加了广告，要更长
        if (window['adEnabled']) {
            NetManager.ins.showLog(getlogItem(37));
            groupHeight = 1624 + window['adWrapHeight'];
            if (DataManager.ins.getData('yyh_signInfo').data && !DataManager.ins.getData('yyh_signInfo').data.addCredits) {
                this['exchangeGroup'].y = 1350 - 150 + window['adWrapHeight'];
                // this['exchangeGroup'].y = 1350 
                this['adgroup'].y = 1350 - 200
            } else {
                this['exchangeGroup'].y = 1350 + 50 + window['adWrapHeight'];
            }

            // this['bg'].height = groupHeight;
            this['adgroup'].visible = true;
            this['adimg'].source = window['adUrl'];
            this['adimg'].y = window['adRect'][1];
            this['adimg'].width = window['adRect'][2];
            this['adimg'].height = window['adRect'][3];
            this['adimg'].once(egret.TouchEvent.TOUCH_TAP, () => {
                NetManager.ins.clickLog(getlogItem(37));
                setTimeout(() => {
                    location.href = window['adLink'];
                }, 200);
            }, this);
        }
        this.sv = groupHeight - this.stage.stageHeight;//拉到底先

        if (DataManager.ins.getData('yyh_signInfo').data && !DataManager.ins.getData('yyh_signInfo').data.addCredits) {
            // 不加积分  隐藏任务按钮和问卷按钮 更改签到样式
            this['qaBtn'].visible = false
            this['taskBtn'].visible = false
            this['warningGroup'].visible = true
            this['signGroup'].visible = false
            this['inviteBtn'].visible = false

        } else {
            this.checkDosign();
            this.clearGuide(1);
            wait(1000).then(() => { this.showAni(4, true) });
        }

        // this.initExchangeList();

        // if (guide) {
        //     this.showGuide();
        //     wait(1000).then(() => { this.showAni(4, true) });
        // }
        // else {

        // }

        this['recordBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_record, this);
        this['inviteBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_inviteBtn, this);
        this['ruleBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this['rule2Btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rule2Btn, this);
        this['qaBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_qaBtn, this);
        this['taskBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_taskBtn, this);
        this['moneyRecord'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_moneyRecord, this);

        this.currentAction = 'standby';

        this.standby = await loadSvga(getResPath() + 'resource/assets/svgas/standby.svga', this['group']) as SVGA.EgretMovieClip;
        this.standby.y = -100; this.standby.x = -50;
        this.standby.touchEnabled = this.standby.touchChildren = false;

        this.jump = await loadSvga(getResPath() + 'resource/assets/svgas/jump.svga', this['group']) as SVGA.EgretMovieClip;
        this.jump.x = 95 - 50; this.jump.y = 352;
        this.jump.visible = false;
        this.jump.gotoAndStop(1);
        this.jump.touchEnabled = this.jump.touchChildren = false;

        this.kiss = await loadSvga(getResPath() + 'resource/assets/svgas/kiss.svga', this['group']) as SVGA.EgretMovieClip;
        this.kiss.x = 105 - 50; this.kiss.y = 375;
        this.kiss.visible = false;
        this.kiss.gotoAndStop(1);
        this.kiss.touchEnabled = this.kiss.touchChildren = false;

        this['group'].addChild(this['standbyBtn']);
        this['group'].addChild(this['actionTextGroup']);
        this['standbyBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_standbyBtn, this);

        this.randomAni();
    }

    randomAni() {
        setInterval(() => {
            if (this._needClick || Math.random() < 0.5) return;
            const num = Math.random() < 0.5 ? 2 : 3;
            this.showAni(num);
        }, 1000 * 20);
    }

    onSkinComplete() {
        super.onSkinComplete()
        this.initExchangeList()
    }

    private list: eui.List;
    public exchangeListGroup: eui.Group
    public exchangeBg: eui.Image
    public bg: eui.Image;
    initExchangeList() {
        let list = DataManager.ins.getData("getExchangeList") && DataManager.ins.getData("getExchangeList").data && DataManager.ins.getData("getExchangeList").data.list ? DataManager.ins.getData("getExchangeList").data.list : []

        let i = 0;


        this.bg.height = 1624 + 200 + (Math.ceil(list.length / 2) - 1) * 350 + 300 + 300;
        if (window['adEnabled'] == 0)
            this.bg.height -= window['adWrapHeight'];
        this.exchangeBg.height = 477 + (Math.ceil(list.length / 2) - 1) * 350 + 30 > 500 ? 477 + (Math.ceil(list.length / 2) - 1) * 350 + 30 : 500;
        this['group1'].y = 477 + (Math.ceil(list.length / 2) - 1) * 350 + 30;
        this['label1'].text = window['exchangeTips1'];

        for (let i = 0; i < list.length; i++) {
            let item = new eui.Component()
            item.skinName = "ExchangeItemSkin";
            item.x = i % 2 * 318
            item.y = (Math.floor(i / 2) * 350)

            item['itemImg'].source = `${list[i].image}`
            item['nametxt'].text = `${list[i].title}`
            item['datetxt'].text = `${list[i].limitStartDate.replace(/-/g, ".")}-${list[i].limitEndDate.replace(/-/g, ".")}`
            item['pricetxt'].text = `${list[i].credits}松果`

            let now = new Date().getTime()
            console.log(this.dateFormatter(list[i].limitStartDate))
            let startTime = new Date(list[i].limitStartDate.replace(/-/g, '/') + " " + window["openTime"]).getTime() || 0
            let endTime = new Date(list[i].limitEndDate.replace(/-/g, '/') + " " + window["closeTime"]).getTime() || 999999999999999999999
            let dpm = Buried.connectDpm(110, 14, i + 1)
            let dcm = Buried.connectDcm(202, list[i].id, 0)
            let exposure = Buried.createExposure(dpm, dcm)
            NetManager.ins.showLog(exposure)
            if (now <= startTime || now >= endTime) {
                // 未到开始时间
                this.setGray(item['btn'])
            } else {
                item['btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                    NetManager.ins.clickLog(exposure)
                    window.location.href = list[i].url
                }, this)
            }

            this.exchangeListGroup.addChild(item)
        }
        this.list.useVirtualLayout = false;
        // this.list.itemRenderer = ExchangeItemRenderer;
        // this.list.dataProvider = new eui.ArrayCollection(DataManager.ins.getData("getExchangeList") && DataManager.ins.getData("getExchangeList").data && DataManager.ins.getData("getExchangeList").data.list ? DataManager.ins.getData("getExchangeList").data.list : [])
        // this.list.dataProvider = new eui.ArrayCollection([1, 2, 3]);
    }

    setGray(target: eui.Image | eui.Group | eui.Component) {
        let colorGrayMatrix = [
            0.3, 0.6, 0, 0, 0,
            0.3, 0.6, 0, 0, 0,
            0.3, 0.6, 0, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorGrayMatrix);

        target.filters = [colorFilter];
    }

    /**
 * 时间格式化
 * @param date    接收可以被new Date()方法转换的内容
 * @param format  字符串，需要的格式例如：'yyyy-MM-dd hh:mm:ss'
 * @returns {String}
 */
    dateFormatter = (date: any, format = 'yyyy-MM-dd') => {
        if (!date) return '-';

        date = new Date(date.replace(/-/g, '/'));
        let o = {
            'M+': date.getMonth() + 1,
            'd+': date.getDate(),
            'h+': date.getHours(),
            'm+': date.getMinutes(),
            's+': date.getSeconds(),
            'q+': Math.floor((date.getMonth() + 3) / 3),
            'S': date.getMilliseconds()
        };
        if (/(y+)/.test(format)) {
            format = format.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
        }
        for (let k in o) {
            if (new RegExp('(' + k + ')').test(format)) {
                format = format.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length)));
            }
        }
        return format;
    };

    async fuck() {
        await wait(2000);
        this.showAni(5, true);
    }

    private _currentGuide;
    private _currentGuideIndex = -1;
    async showGuide() {

        this['skipBtn'].once(egret.TouchEvent.TOUCH_TAP, async () => {
            await this.playHideAni([
                this._currentGuide,
                this['skipBtn'],
                this['guide' + this._currentGuideIndex]
            ]);
            this.clearGuide();
            this.removeChild(this._currentGuide);
            this._currentGuide = null;
        }, this);
        for (let i = 1; i <= this.STEP_MAX; i++) {
            this['nextbtn' + i]['__buired_index__'] = i - 1;
            this['nextbtn' + i].once(egret.TouchEvent.TOUCH_TAP, this.onNextGuide, this)
        }

        this['skipBtn'].visible = true;
        this.onNextGuide();
    }

    async playHideAni(objs: any[]) {
        return new Promise((r) => {
            const obj = objs.pop();
            const dur = 200;
            objs.forEach(item => {
                egret.Tween.get(item).to({ alpha: 0 }, dur);
            })
            egret.Tween.get(obj).to({ alpha: 0 }, dur).call(r);
        });
    }
    async playShowAni(objs: any[], dur = 200) {
        return new Promise((r) => {
            const obj = objs.pop();
            objs.forEach(item => {
                egret.Tween.get(item).set({ alpha: 0 }).to({ alpha: 1 }, dur);
            })
            egret.Tween.get(obj).set({ alpha: 0 }).to({ alpha: 1 }, dur).call(r);
        });
    }

    private async onNextGuide(e?: egret.Event) {
        if (e) {
            this.clickGuidelog(e.target['__buired_index__']);
            console.log(e.target['__buired_index__'])
        }
        if (this._currentGuideIndex == -1) {
            this._currentGuideIndex = 1;
        } else {
            await this.playHideAni([
                this._currentGuide,
                this['skipBtn'],
                this['guide' + this._currentGuideIndex]
            ]);
            this.removeChild(this._currentGuide);
            this._currentGuideIndex++;
        }

        if (this._currentGuideIndex == this.STEP_MAX) {
            this['skipBtn'].visible = false;
        }
        if (this._currentGuideIndex > this.STEP_MAX) {
            this.clearGuide();
            return;
        }

        this._currentGuide = this.getGuideBg(this._currentGuideIndex);
        this.addChild(this._currentGuide);
        this.showGuidelog(this._currentGuideIndex - 1);
        this.addChild(this['guide' + this._currentGuideIndex]);
        this['guide' + this._currentGuideIndex].visible = true;
        this.addChild(this['skipBtn']);
        this._currentGuide.alpha = 0;
        this['skipBtn'].alpha = 0;
        this['guide' + this._currentGuideIndex].alpha = 0;

        if (this._currentGuideIndex == this.STEP_MAX) {
            await new Promise((r) => { egret.Tween.get(this.scroll.viewport).to({ scrollV: this.sv }, 200).call(r); })
        }
        await this.playShowAni([
            this._currentGuide,
            this['skipBtn'],
            this['guide' + this._currentGuideIndex]
        ], this._currentGuideIndex == 1 ? 1 : 200);
    }

    getGuideBg(index) {
        switch (index) {
            case 1:
                return getGuideBg1(this.stage.stageWidth, this.stage.stageHeight);
            case 2:
                return getGuideBg2(this.stage.stageWidth, this.stage.stageHeight);
            case 3:
                return getGuideBg3(this.stage.stageWidth, this.stage.stageHeight);
            case 4:
                return getGuideBg4(this.stage.stageWidth, this.stage.stageHeight);
            case 5:
                return getGuideBg5(this.stage.stageWidth, this.stage.stageHeight, this.stage.stageHeight - 437 - 13);
        }
    }

    pollingCredit() {
        //签到之后才需要
        let counter = 10;
        while (counter > 0) {
            wait(counter * 500).then(() => {
                this.updateCredits();
            });
            counter--;
        }
    }

    clearGuide(notSendData?) {
        this.removeChild(this['guide1']);
        this.removeChild(this['guide2']);
        this.removeChild(this['guide3']);
        this.removeChild(this['guide4']);
        this.removeChild(this['guide5']);
        this.removeChild(this['skipBtn']);
        egret.Tween.get(this.scroll.viewport).to({ scrollV: 0 }, 200);
        if (!notSendData) {
            NetManager.ins.yyh_join_1_join(() => { });
            NetManager.ins.yyh_dosign((s) => {
                if (!s)
                    showToast('签到失败，请今日之内联系客服。');
                else {
                    const dosign = DataManager.ins.getData('yyh_dosign').data;
                    PanelCtrl.instance.show('SignPanel', { id: dosign.prizeId });
                }
                this.updateSignInfo();
                // this.updateCredits();
                this.pollingCredit();
            });
        }
    }

    private checkDosign() {
        const signInfo = DataManager.ins.getData('yyh_signInfo').data;
        if (!signInfo.todaySigned && signInfo.continueDay < 7) {
            NetManager.ins.yyh_dosign((s) => {
                if (!s)
                    showToast('签到失败，请今日之内联系客服。');
                else {
                    const dosign = DataManager.ins.getData('yyh_dosign').data;
                    if (dosign.breakDays > 0) {
                        this.fuck();
                    }
                    const continueDay = dosign.continueDay;
                    if (dosign.prizeId) {
                        if (continueDay == 1) {
                            PanelCtrl.instance.show('Sign1Panel', { id: dosign.prizeId });
                        } else if (continueDay == 7) {
                            PanelCtrl.instance.show('Sign7Panel', { id: dosign.prizeId });
                        } else {
                            PanelCtrl.instance.show('Sign3Panel', { id: dosign.prizeId });
                        }
                    } else {
                        PanelCtrl.instance.show('SignNoPrizePanel')
                    }

                }
                this.updateSignInfo();
                this.pollingCredit();
            });
        } else {
            this.updateSignInfo();
        }
    }

    updateSignInfo() {
        NetManager.ins.yyh_signInfo(() => {
            const signInfo = DataManager.ins.getData('yyh_signInfo').data;
            this['signConTips'].text = `已连续签到${signInfo.continueDay}天`;
            for (let i = 1; i <= 7; i++) {
                if (i <= signInfo.continueDay)
                    this['signed' + i].visible = true;
            }
        })
    }

    _clickCounter = 0;
    onTap_standbyBtn() {
        if (this._needClick) {
            this._needClick = false;
            egret.Tween.get(this['actionTextGroup']).to({ alpha: 0 }, 500);
            //     return;
        }
        this['standbyBtn'].touchEnabled = false;
        this._clickCounter++;
        if (this._clickCounter % 2 == 1) {
            this.changeAction('kiss');
            this.showAni(1);
        }
        else {
            this.showAni(6);
            this.changeAction('jump');
        }
        this['actionTextGroup'].visible = true;
        // this.showAni();
    }

    _needClick;
    showAni(num = 4, isFirst = false) {
        this['actionText1'].visible = false;
        this['actionText2'].visible = false;
        this['actionText3'].visible = false;
        this['actionText4'].visible = false;
        this['actionText5'].visible = false;
        this['actionText6'].visible = false;
        this['actionText' + num].visible = true;
        egret.Tween.removeTweens(this['actionTextGroup']);
        if (isFirst) {
            this._needClick = true;
            egret.Tween.get(this['actionTextGroup']).set({ scaleX: 0, scaleY: 0, alpha: 1 }).to({ scaleX: 1, scaleY: 1 }, 200, egret.Ease.getBackOut(2));
        } else {
            egret.Tween.get(this['actionTextGroup']).set({ scaleX: 0, scaleY: 0, alpha: 1 }).to({ scaleX: 1, scaleY: 1 }, 200, egret.Ease.getBackOut(2))
                .wait(2000).to({ alpha: 0 }, 500);
        }
    }

    changeAction(action: string, once = true) {
        this[this.currentAction].visible = false;
        this[this.currentAction].gotoAndStop(1);

        this[action].visible = true;
        this[action].gotoAndPlay(1, true);
        this.currentAction = action;

        if (once) {
            this[action].once(egret.Event.COMPLETE, () => {
                this[this.currentAction].gotoAndStop(1);
                this.changeAction('standby');
                this['standbyBtn'].touchEnabled = true;
            }, this);
        }
        // else {
        //     this['standbyBtn'].touchEnabled = true;
        // }
    }

    onTap_moneyRecord() {
        SceneCtrl.instance.change('MoneyScene');
        NetManager.ins.clickLog(getlogItem(8));
    }
    onTap_record() {
        NetManager.ins.clickLog(getlogItem(13));
        setTimeout(() => {
            location.href = window['recordUrl'];
        }, 200);
    }

    onTap_inviteBtn() {
        NetManager.ins.clickLog(getlogItem(9));
        this.touchEnabled = false;
        this.touchChildren = false;
        NetManager.ins.yyh_bindInfo(() => {
            this.touchEnabled = true;
            this.touchChildren = true;
            const bindInfo = DataManager.ins.getData('yyh_bindInfo');
            if (bindInfo.data && bindInfo.data.recommendCode) {
                SceneCtrl.instance.change('InviteScene');
            } else {
                SceneCtrl.instance.change('SubmitInviteScene');
            }
        })
    }

    updateCredits() {
        NetManager.ins.getProjectUserInfo(() => {
            const userInfo = DataManager.ins.getData('getProjectUserInfo').data;
            this['moneyTxt'].text = userInfo.consumerCredits;
        })
    }

    onTap_ruleBtn() {
        NetManager.ins.clickLog(getlogItem(10));
        PanelCtrl.instance.show('RulePanel');
    }
    onTap_rule2Btn() {
        PanelCtrl.instance.show('RulePanel2');
    }
    onTap_qaBtn() {
        NetManager.ins.clickLog(getlogItem(11));
        const questions: any[] = DataManager.ins.getData('yyh_questionInfo').data.questions;
        const complete = questions.every(q => q.userAnswer !== null);
        if (complete) {
            SceneCtrl.instance.change('QAScene2');
        } else
            SceneCtrl.instance.change('QAScene');
    }
    onTap_taskBtn() {
        NetManager.ins.clickLog(getlogItem(12));
        PanelCtrl.instance.show('TaskPanel');

    }

    get skinKey() { return 'Main' }

    showlog() {
        NetManager.ins.showLog(getlogItem(8));
        NetManager.ins.showLog(getlogItem(9));
        NetManager.ins.showLog(getlogItem(10));
        NetManager.ins.showLog(getlogItem(11));
        NetManager.ins.showLog(getlogItem(12));
        NetManager.ins.showLog(getlogItem(13));
        NetManager.ins.showLog(getlogItem(14));
        NetManager.ins.showLog(getlogItem(15));
    }
    showGuidelog(index) {
        const list = [2, 3, 4, 5, 6];
        NetManager.ins.showLog(getlogItem(list[index]));
    }
    clickGuidelog(index) {
        const list = [2, 3, 4, 5, 6];
        NetManager.ins.clickLog(getlogItem(list[index]));
    }
}