import getResPath from "../libs/new_tc/getResPath";
import AssetAdapter from "../libs/new_wx/adapter/AssetAdapter";
import ThemeAdapter from "../libs/new_wx/adapter/ThemeAdapter";
import Loading from "../libs/new_wx/components/Loading";
import PanelCtrl from "../libs/new_wx/ctrls/panelCtrl";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import layers from "../libs/new_wx/views/layers";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetManager } from "../libs/tw/manager/NetManager";
import InviteScene from "./InviteScene";
import LoadingScene from "./LoadingScene";
import MainScene from "./MainScene";
import MoneyScene from "./MoneyScene";
import QAFailPanel from "./panels/QAFailPanel";
import QASuccessPanel from "./panels/QASuccessPanel";
import RulePanel from "./panels/RulePanel";
import RulePanel2 from "./panels/RulePanel2";
import Sign1Panel from "./panels/Sign1Panel";
import Sign3Panel from "./panels/Sign3Panel";
import Sign7Panel from "./panels/Sign7Panel";
import SignPanel from "./panels/SignPanel";
import TaskPanel from "./panels/TaskPanel";
import SignNoPrizePanel from './panels/SignNoPrizePanel';
import QAScene from "./QAScene";
import QAScene2 from "./QAScene2";
import StartScene from "./StartScene";
import SubmitInviteScene from "./SubmitInviteScene";
import BindCardScene from "./BindCardScene";
import { Buried } from "../libs/tw/util/Buried";


export default class MainBase extends eui.UILayer {
    constructor() {
        super();
        Loading.instace.loadImage();
        DataManager.ins.customCfgData = window['CFG'];
        this.getData();
    }

    protected registerModules() {
        const panels = [
            ['QASuccessPanel', { cls: QASuccessPanel }],
            ['QAFailPanel', { cls: QAFailPanel }],
            ['TaskPanel', { cls: TaskPanel }],
            ['RulePanel', { cls: RulePanel }],
            ['RulePanel2', { cls: RulePanel2 }],
            ['SignPanel', { cls: SignPanel }],
            ['Sign1Panel', { cls: Sign1Panel }],
            ['Sign3Panel', { cls: Sign3Panel }],
            ['Sign7Panel', { cls: Sign7Panel }],
            ['SignNoPrizePanel', { cls: SignNoPrizePanel }],
        ];
        const scenes = [
            ['BindCardScene', { cls: BindCardScene }],
            ['QAScene', { cls: QAScene }],
            ['QAScene2', { cls: QAScene2 }],
            ['QAFailPanel', { cls: QAFailPanel }],
            ['QASuccessPanel', { cls: QASuccessPanel }],
            ['MoneyScene', { cls: MoneyScene }],
            ['LoadingScene', { cls: LoadingScene }],
            ['StartScene', { cls: StartScene }],
            ['MainScene', { cls: MainScene }],
            ['InviteScene', { cls: InviteScene }],
            ['SubmitInviteScene', { cls: SubmitInviteScene }],
        ];

        panels.forEach(item => PanelCtrl.instance.registerPanel(item[0], item[1]));
        scenes.forEach(item => SceneCtrl.instance.registerScene(item[0], item[1]));

    }

    protected getData() {

    }

    static onPause_mainscene;
    static onResume_mainscene;
    protected createChildren(): void {
        super.createChildren();
        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        egret.lifecycle.onPause = () => {
            // egret.ticker.pause();
            // console.log('pause')
        }

        egret.lifecycle.onResume = () => {
            // egret.ticker.resume();
            // console.log('onResume')
        }

        //inject the custom material parser
        //注入自定义的素材解析器
        const assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        layers.init(this);
        Loading.init(layers.topLayer);
        // Loading.instace.show();

        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        this.registerModules();

        // Loading.instace.show();

        RES.setMaxLoadingThread(10);
        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()

        if (!window['development']) {//正式环境
            RES.getResAsync(`common_json`);//弱网下需要toast资源的缓存

        }
        else {
        }

        RES.getResAsync(`nums_fnt`);
        RES.getResAsync(`nums_png`);

        this.createGameScene();
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            const theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);
        })
    }

    protected async createGameScene() {
        if (window["isAutoLoginPage"]) {
            this.autoLogin()
            return
        }

        if (window['isBindCardPage']) {
            SceneCtrl.instance.change('BindCardScene');
            return
        }

        if (!window['isInvitePage']) {
            await Promise.all([
                new Promise((r) => { NetManager.ins.yyh_queryMyJoin(r) }),
                new Promise((r) => { NetManager.ins.yyh_signInfo(r) }),
                new Promise((r) => { NetManager.ins.yyh_queryPrize(r) }),
                new Promise((r) => { NetManager.ins.yyh_questionInfo(r) }),
                new Promise((r) => { NetManager.ins.getProjectUserInfo(r) }),
                new Promise((r) => { NetManager.ins.getExchangeList(r) })
            ]);
        }

        SceneCtrl.instance.change('LoadingScene');
        Buried.init();
    }


    // getProjectUserInfo() {
    //     return new Promise((r) => {
    //         NetManager.ins.getProjectUserInfo(async () => {

    //             r();
    //         });
    //     })
    // }
    // ajaxElement() {
    //     return new Promise((r) => {
    //         NetManager.ins.ajaxElement(async () => {
    //             Buried.init();
    //             r();
    //         });
    //     })
    // }
    // getIndex() {
    //     return new Promise((r) => {
    //         NetManager.ins.yyh_index(async (success) => {
    //             if (!success) {
    //                 location.href = 'https://activity-1.m.duiba.com.cn/customShare/share?id=3627'
    //             } else
    //                 r();
    //         });
    //     })
    // }

    autoLogin() {
        NetManager.ins.getLoginInfo((s) => {
            if (!s) {
                // 错误处理
                return
            }

            let { corpNo, timestamp, nonceStr, sign } = DataManager.ins.getData("getLoginInfo").data
            window['cmblapi'].merchantLogin({
                corpNo: corpNo,
                reAuth: false,
                authInfo: {
                    timestamp: timestamp,
                    nonceStr: nonceStr,
                    sign: sign
                },
                success: function (res) {
                    // res结果如下:
                    // {body ="xxx",cryptType = 2,resultType = Y}
                    NetManager.ins.getAutoLoginUrl((ss) => {
                        if (!ss) {
                            return
                        }
                        let url = DataManager.ins.getData("getAutoLoginUrl").data
                        window.location.href = url
                    }, res)
                },
                fail: function (res) {

                }
            })
        })
    }
}