import Scene from "../libs/new_wx/components/Scene";
import { Buried } from "../libs/tw/util/Buried";
import { loadSvga, loadSvgaRes } from "./loadSvga";
import getResPath from "../libs/new_tc/getResPath";
import wait from "../libs/new_tc/wait";
import SceneCtrl from "../libs/new_wx/ctrls/sceneCtrl";
import { DataManager } from "../libs/tw/manager/DataManager";
//提前加载需要的资源，比如开始场景，等等
export default class LoadingScene extends Scene {

    mc: SVGA.EgretMovieClip;
    mc2: SVGA.EgretMovieClip;
    async start(d?) {
        await Promise.all([
            loadSvgaRes(getResPath() + 'resource/assets/svgas/progress.svga'),
            loadSvgaRes(getResPath() + 'resource/assets/svgas/progress2.svga'),
        ]);
        this.mc = await loadSvga(getResPath() + 'resource/assets/svgas/progress.svga', this) as SVGA.EgretMovieClip;
        this.mc2 = await loadSvga(getResPath() + 'resource/assets/svgas/progress2.svga', this) as SVGA.EgretMovieClip;
        this.mc.gotoAndStop(1);
        this.mc2.gotoAndStop(1);
        this.mc2.x = 210; this.mc2.y = 580;
        const totalFrames = this.mc.totalFrames;
        const SPEED = 30;
        let timer;
        let count = 0;

        const setProgress = async () => {
            const key = Math.ceil(count / 100 * totalFrames);
            this.mc.gotoAndStop(key);
            this.mc2.gotoAndStop(key);
            if (count >= 90) {
                clearInterval(timer);
            }
        };

        timer = setInterval(() => {
            count++;
            setProgress();
        }, 1000 / SPEED);

        if (!window['development']) {//正式环境
            await Promise.all([
                RES.getResAsync(`start_jpg`),
                RES.getResAsync(`start_json`),
                RES.getResAsync(`start_png`),
                RES.getResAsync(`main_json`),
                RES.getResAsync(`main_png`),
                RES.getResAsync(`mainbg_jpg`),
                loadSvgaRes(getResPath() + 'resource/assets/svgas/title.svga'),
                loadSvgaRes(getResPath() + 'resource/assets/svgas/jump.svga'),
                loadSvgaRes(getResPath() + 'resource/assets/svgas/btn.svga'),
                loadSvgaRes(getResPath() + 'resource/assets/svgas/kiss.svga'),
                loadSvgaRes(getResPath() + 'resource/assets/svgas/standby.svga'),
            ]);
        }

        clearInterval(timer);
        this.mc.gotoAndStop(totalFrames);
        this.mc2.gotoAndStop(totalFrames);

        wait(200).then(() => {
            const data = DataManager.ins.getData('yyh_queryMyJoin') && DataManager.ins.getData('yyh_queryMyJoin').data;

            if (window['isInvitePage'] !== 1 && data && data.total > 0)
                SceneCtrl.instance.change('MainScene');
            else
                SceneCtrl.instance.change('StartScene');

        });
    }

    get skinKey() { return 'Loading' }
    get resKey() { return 'noname' }

    showlog() { }
}

export const getlogItem = (i) => {
    const Dpm = Buried.connectDpm(110, i, 1); // 点击埋点
    const Dcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
    return Buried.createExposure(Dpm, Dcm);
}