const getMaskIcon1 = () => {
    let maskIcon: egret.Shape = new egret.Shape();
    maskIcon.graphics.beginFill(0x000000, 1);
    maskIcon.graphics.drawRoundRect(0, 0, 651,268,50,50);
    maskIcon.graphics.endFill();
    maskIcon.x = 51;
    maskIcon.y = 753+10;
    return maskIcon
}

const getMaskIcon2 = () => {
    let maskIcon: egret.Shape = new egret.Shape();
    maskIcon.graphics.beginFill(0x000000, 1);
    maskIcon.graphics.drawRoundRect(0, 0, 150,150,150,150);
    maskIcon.graphics.endFill();
    maskIcon.x = 591;
    maskIcon.y = 174-5;
    return maskIcon
}
const getMaskIcon3 = () => {
    let maskIcon: egret.Shape = new egret.Shape();
    maskIcon.graphics.beginFill(0x000000, 1);
    maskIcon.graphics.drawRoundRect(0, 0, 150,150,150,150);
    maskIcon.graphics.endFill();
    maskIcon.x = 591;
    maskIcon.y = 174-5+145+3;
    return maskIcon
}
const getMaskIcon4 = () => {
    let maskIcon: egret.Shape = new egret.Shape();
    maskIcon.graphics.beginFill(0x000000, 1);
    maskIcon.graphics.drawRoundRect(0, 0, 240,130,20,20);
    maskIcon.graphics.endFill();
    maskIcon.x = 20+5;
    maskIcon.y = 16+5;
    return maskIcon
}
const getMaskIcon5 = (y) => {
    let maskIcon: egret.Shape = new egret.Shape();
    maskIcon.graphics.beginFill(0x000000, 1);
    maskIcon.graphics.drawRoundRect(0, 0, 314,343,20,20);
    maskIcon.graphics.endFill();
    maskIcon.x = 56+3;
    maskIcon.y = y;
    return maskIcon
}

export const getGuideBg1 = (w,h) => {
    let guide = new GuideBG();
    guide.init(getMaskIcon1(), w, h);
    return guide;
};
export const getGuideBg2 = (w,h) => {
    let guide = new GuideBG();
    guide.init(getMaskIcon2(), w, h);
    return guide;
};
export const getGuideBg3 = (w,h) => {
    let guide = new GuideBG();
    guide.init(getMaskIcon3(), w, h);
    return guide;
};
export const getGuideBg4 = (w,h) => {
    let guide = new GuideBG();
    guide.init(getMaskIcon4(), w, h);
    return guide;
};
export const getGuideBg5 = (w,h,y) => {
    let guide = new GuideBG();
    guide.init(getMaskIcon5(y), w, h);
    return guide;
};

class GuideBG extends egret.Sprite {
    constructor() {
        super();
    }
    /**
     * dp 确保已经定位并且没有加入到显示列表中。
     */
    public init(maskIcon: egret.DisplayObject, w: number, h: number): void {
        let container = new egret.Sprite();
        this.touchEnabled = true;
        let bg = new egret.Shape();
        bg.graphics.beginFill(0x000000, 0.65);
        bg.graphics.drawRect(0, 0, w, h);
        bg.graphics.endFill();

        container.addChild(bg);

        container.addChild(maskIcon);

        maskIcon.blendMode = egret.BlendMode.ERASE;

        let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        renderTexture.drawToTexture(container);

        let bitmap: egret.Bitmap = new egret.Bitmap(renderTexture);
        // bitmap.pixelHitTest = true;

        this.addChild(bitmap);

        this.once(egret.TouchEvent.TOUCH_TAP,()=>{
            // this.parent.removeChild(this);
        },this);
    }
}






