import { DataManager } from './../libs/tw/manager/DataManager';
import getSkinPath from "../libs/new_wx/utils/getSkinPath";
import setGray from "./setGray";


export default class ExchangeItemRenderer extends eui.ItemRenderer {

    public itemImg: eui.Image;
    public btn: eui.Image;
    public nametxt: eui.Label;
    public datetxt: eui.Label;
    public pricetxt: eui.Label;


    constructor() {
        super();
        this.skinName = getSkinPath('ExchangeItem');


    }

    dataChanged() {
        console.log("idx:", this.itemIndex);

        this.itemImg.source = `${this.data.image}`
        this.nametxt.text = `${this.data.title}`
        this.datetxt.text = `${this.data.limitStartDate.replace(/-/g, ".")}-${this.data.limitEndDate.replace(/-/g, ".")}`
        this.pricetxt.text = `${this.data.credits}松果`

        this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, () => { window.location.href = this.data.url }, this)
        // if (this.data % 2)
        //     setGray(this);
    }
}