import getSkinPath from "../libs/new_wx/utils/getSkinPath";


export default class AdminItemRenderer extends eui.ItemRenderer {
    constructor() {
        super();
        this.skinName = getSkinPath('AdminItem');
    }
    btn: eui.Button;
    dataChanged() {
        if (!this['img'].mask)
            this['img'].mask = this['imgMask'];
        if (!this.btn.hasEventListener(egret.TouchEvent.TOUCH_TAP)) {
            this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, () => { this.data.func(this.data.item) }, this);
        }
        this['img'].source = null;

        this.loadImg();
        console.log(this.data.item)
    }

    loadImg() {
        const maskRatio = this['imgMask'].width / this['imgMask'].height;
        const url = 'http://yun.duiba.com.cn/db_games/img1.png';
        // const url = 'http://yun.duiba.com.cn/db_games/img2.jpg';
        RES.getResByUrl(url, (img: egret.Texture) => {
            this['img'].source = img;
            
            const imgRatio = img.textureWidth / img.textureHeight;

            if (imgRatio < maskRatio) {
                const scale = this['imgMask'].width / img.textureWidth;
                this['img'].width = this['imgMask'].width;
                this['img'].height = img.textureHeight * scale;
                this['img'].y = 5.1 - this['img'].height / 2 + this['imgMask'].height / 2;
            } else {
                const scale2 = this['imgMask'].height / img.textureHeight;
                this['img'].height = this['imgMask'].height;
                this['img'].width = img.textureWidth * scale2;
                this['img'].x = 31.7 - this['img'].width / 2 + this['imgMask'].width / 2;
            }



        }, this, RES.ResourceItem.TYPE_IMAGE);
    }
}