import { Data } from './../data/Data';
// import { ABNetManager, GTime, INetData, GDispatcher } from "duiba-tc";
import { TwLang } from "../util/TwLang";
import { DataManager } from "./DataManager";
import { NetName } from '../enum/NetName';
import { ABNetManager } from '../../tc/manager/ABNetManager';
import { INetData } from '../../tc/interface/INetData';
import { GTime } from '../../tc/util/GTime';
import { IExposureData } from '../data/common/IExposureData';
import { GDispatcher } from '../../tc/util/GDispatcher';
import onNotSuccess from '../../new_wx/onNotSuccess';
// import { IExposureData } from '..';

export class NetManager extends ABNetManager {
    private static instance: NetManager;

    public static get ins(): NetManager {
        if (!this.instance) {
            this.instance = new NetManager();
        }
        return this.instance;
    }

    private isInit: boolean;
    constructor() {
        super();
        if (this.isInit) {
            throw Error(TwLang.lang_001);
        }
        this.isInit = true;
    }

    /**
     * 获取用户角色信息
     * @param {number} roleActivityId 角色id
     * @param {number} type 类型
     */
    public getRole(callback: Function, roleActivityId: string, type = 1): void {
        const net: INetData = {
            name: NetName.GET_ROLE,
            uri: '/activityCommon/getRole',
            type: 'get',
            dataType: 'json',
            param: {
                id: roleActivityId,
                type: type
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 活动设置用户角色信息
     * @param {number} actId  活动id
     * @param {number} type 活动类型 0:插件活动; 1:入库活动
     * @param {string} role 角色信息，不能超过32个字符
     */
    public setRole(callback: Function, actId: number, type: number, role: string): void {
        const net: INetData = {
            name: NetName.SET_ROLE,
            uri: '/activityCommon/setRole',
            type: 'post',
            dataType: 'json',
            param: {
                id: actId,
                type: type,
                role: role
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 查询用户现在的剩余积分
     */
    public getCredits(callback: Function): void {
        const net: INetData = {
            name: NetName.GET_CREDITS,
            uri: '/ctool/getCredits',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    }

    /**
     * 增加活动免费次数
     * @param {number} type 1游戏、2活动工具
     * @param {number} count 次数
     * @param {number} validType 如果不传该参数，代表增加的次数是该用户可以永久使用的次数；如果传该参数，代表增加的次数是仅当天可用的，该参数值只能是1
     */
    public addTimesForActivity(callback: Function, count: number, validType: number): void {
        let activityId = DataManager.ins.customCfgData.oaId;

        const param: any = {
            timestamp: GTime.getTimestamp(),
            addCount: count,
            activityId: activityId
        };
        if (validType) {
            param.validType = validType;
        }

        const net: INetData = {
            name: NetName.ADD_TIMES,
            uri: '/activityVist/addTimesForActivity',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    /**
     * 获取集卡数据
     * @param {number} collectRuleId 集卡规则ID
     */
    public getCollectRule(callback: Function, collectRuleId: number): void {
        const net: INetData = {
            name: NetName.COLLECT_RULE,
            uri: '/collectRule/getCollectRule',
            type: 'get',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 集卡开奖
     * @param {number} collectRuleId 集卡规则ID
     * @param {number} type 1游戏、2活动工具、其他类型可以不传，发接口actid也不用传
     */
    public openCollectGoodsPrize(callback: Function, collectRuleId: number, type?: number): void {
        let actId: number;
        let param: any;
        if (type == 1) {
            actId = DataManager.ins.gameCfgData.gameInfo.oaId;
        } else if (type == 2) {
            actId = DataManager.ins.customCfgData.oaId;
        }
        if (type) {
            param = { collectRuleId: collectRuleId, actId: actId }
        } else {
            param = { collectRuleId: collectRuleId };
        }
        const net: INetData = {
            name: NetName.OPEN_COLLECT,
            uri: '/collectRule/openCollectGoodsPrize',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    //--------------------------------------------游戏-----------------------------------------

    /**
     * 游戏基础信息
     */
    public getInfo(callback?: Function): void {
        const net: INetData = {
            name: NetName.GAME_INFO,
            uri: '/ngame/new/getInfo',
            type: 'get',
            dataType: 'json',
            param: {
                id: DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 夏日活动游戏基础信息
     */
    public getSummerInfo(callback: Function, rankBaseConfigId: number): void {
        const net: INetData = {
            name: NetName.GAME_SUMMERINFO,
            uri: '/summer/getUserActivityInfo',
            type: 'get',
            dataType: 'json',
            param: {
                rankBaseConfigId: rankBaseConfigId,
                isMainActivity: false
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     *  购买鱼钩鱼线道具
     * @param callback 
     * @param operatingActivityId 活动oaid
     * @param type 道具类型 0：鱼线 1：鱼钩
     */
    public summerBuyProp(callback: Function, operatingActivityId: number, type: number): void {
        const net: INetData = {
            name: NetName.GAME_SUMMER_BUYPROP,
            uri: '/summer/buyProp',
            type: 'post',
            dataType: 'json',
            param: {
                operatingActivityId: operatingActivityId,
                type: type
            },
            callback: callback, hideMsg: true
        };
        this.send(net);
    }

    /**
     * 获取鱼钩鱼线数量
     * @param callback 
     */
    public summerGetToyInfo(operatingActivityId, callback: Function): void {
        const net: INetData = {
            name: NetName.GAME_SUMMER_GET_TOY_INFO,
            uri: '/summer/getToyInfo',
            type: 'get',
            dataType: 'json',
            param: { operatingActivityId: operatingActivityId },
            callback: callback
        };
        this.send(net);
    }



    /**
     * 开始游戏
     * @param {string} isAgain 是否是再来一次
     * @param {number} credits 主动要求花费多少积分玩游戏
     * @param {number} customizedType xx类型
     */
    public doStart(callback: Function, isAgain: boolean, credits?: number, customizedType?: number): void {

        let addUrl = '';
        if (isAgain) {
            addUrl += '?dpm=' + DataManager.ins.gameGetSubmitResultData.againExposure.dpm;
        }

        const param: any = {
            id: DataManager.ins.gameCfgData.gameInfo.gameId,
            oaId: DataManager.ins.gameCfgData.gameInfo.oaId
        };

        if (credits) {
            param.credits = credits;
        }

        if (customizedType) {
            param.customizedType = customizedType;
        }

        const net: INetData = {
            name: NetName.GAME_START,
            uri: '/ngapi/dostart',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            addUrl: addUrl
        };
        this.getToken(net);
    }

    /**
     * 查询开始游戏状态
     * @param {number} ticketId 订单ID
     * @param {Function} pollingCheck 轮询条件 返回true继续轮询
     * @param {number} pollingCount 最大轮询次数
     * @param {number} customizedType
     */
    public getStartStatus(callback: Function, ticketId: number, pollingCheck: Function, pollingCount = 5, customizedType?: number): void {
        const param: any = {
            ticketId: ticketId
        };
        if (customizedType) {
            param.customizedType = customizedType
        }

        const net: INetData = {
            name: NetName.GAME_START_STATUS,
            uri: '/ngapi/getStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    }

    public getSummerOrderStatus(callback: Function, orderNum: number, pollingCheck: Function, pollingCount = 5, customizedType?: number): void {
        const param: any = {
            orderNum: orderNum
        };

        const net: INetData = {
            name: NetName.GAME_SUMMER_GET_ORDER_STATUS,
            uri: '/summer/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    }
    /**
     * 复活
     */
    public doRevive(callback: Function, collectRuleId: number, itemId: number): void {

        const net: INetData = {
            name: NetName.GAME_REVIVE,
            uri: '/summer/doRevive',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId,
                itemId: itemId
            },
            callback: callback,
        };
        this.getToken(net);
    }
    /**
     * 获得复活卡数量
     */
    public getReviveCardNum(callback: Function, collectRuleId: number, itemId: number): void {
        const net: INetData = {
            name: NetName.GAME_REVIVE_STATUS,
            uri: '/summer/getReviveCardNum',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId,
                itemId: itemId
            },
            callback: callback,
        };

        this.getToken(net);
    }
    /**
     * 猜扑克
     * @param {number} pluginId 插件ID
     * @param {number} ticketId 订单ID
     * @param {number} prizeId 集卡规则ID
     * @param {number} betting 下注方式 0:大 1:小 2:红 3:黑
     */
    public guessPoker(callback: Function, plugId: number, ticketId: number, prizeId: number, betting: number): void {
        const net: INetData = {
            name: NetName.GAME_GUESS_POKER,
            uri: '/ngapi/guessPoker',
            type: 'post',
            dataType: 'json',
            param: {
                pluginId: plugId,
                ticketId: ticketId,
                prizeId: prizeId,
                betting: betting
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 游戏阶段性数据提交
     * @param ticketId 
     * @param dynamicData 阶段性交互数据
     */
    public datapash(callback: Function, ticketId: number, dynamicData: string): void {
        const net: INetData = {
            name: NetName.GAME_DATA_PASH,
            uri: '/ngame/new/datapash',
            type: 'post',
            dataType: 'json',
            param: {
                ticketId: ticketId,
                gameId: DataManager.ins.gameCfgData.gameInfo.id,
                dynamicData: dynamicData
            },
            callback: callback
        };
        this.send(net);
    }

    ngameSubmit(callback: Function, orderId: number, score: number, gameData: any, dynamicData: any, submitToken: string, rankId?: number): void {
        const sign = this.createSgin(orderId, score, gameData, submitToken);
        const param: any = {
            orderId: orderId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: JSON.stringify(dynamicData)
        };
        if (rankId) {
            param.rankId = rankId;
        }
        const net: INetData = {
            name: 'ngameSubmit',
            uri: '/hdtool/recon/ngame/ngameSubmit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        this.send(net);
    }

    getOrderStatus(callback: Function, orderId: number, pollingCheck?: Function, pollingCount = 10): void {
        const param: any = {
            orderId: orderId
        };
        const net: INetData = {
            name: NetName.CUSTOM_ORDER_STATUS,
            uri: '/hdtool/recon/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager.ins.send(net);
    }

    /**
     * 提交游戏数据
     *
     * @param {number} ticketId 订单ID
     * @param {number} score 分数
     * @param {any} gameData 防作弊信息
     * @param {string} submitToken
     * @param {string} dynamicData 行为数据
     * @param {boolean} checkScore 是否校验分数
     * @param {number} customizedType
     */
    public gameSubmit(callback: Function,
        ticketId: number,
        score: number,
        gameData: any,
        submitToken: string,
        dynamicData: string,
        checkScore?: boolean,
        customizedType?: number): void {
        const sign = this.createSgin(ticketId, score, gameData, submitToken);
        const param: any = {
            ticketId: ticketId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: dynamicData
        };
        if (checkScore) {
            param.checkScore = checkScore;
        }
        if (customizedType) {
            param.customizedType = customizedType;
        }

        const net: INetData = {
            name: NetName.GAME_SUBMIT,
            uri: '/ngame/new/submit',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    /**
     * 生成签名
     * @param {number} ticketId
     * @param {number} score
     * @param {any} gameData
     * @param {string} submitToken
     * @returns {string} 签名
     */
    private createSgin(ticketId: number, score: number, gameData: any, submitToken: string): string {
        return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
    }

    /**
     * 游戏结束获取奖品数据
     * @param {number} orderId 订单ID 
     * @param {Function} pollingCheck 轮询条件 返回true继续轮询
     * @param {number} 最大轮询次数
     */
    public getSubmitResult(callback: Function, orderId: number, pollingCheck: Function, pollingCount = 5): void {
        const net: INetData = {
            name: NetName.GAME_SUBMIT_STATUS,
            uri: '/ngame/new/getSubmitResult',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    }

    /**
     * 查看中奖名单
     * @param {boolean} showName 是否返回昵称
     */
    public winRanks(callback: Function, showName = false): void {
        const net: INetData = {
            name: NetName.GAME_RANKS,
            uri: '/ngapi/winranks',
            type: 'post',
            dataType: 'json',
            param: {
                id: DataManager.ins.gameCfgData.gameInfo.gameId,
                showName: showName
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     *  获取奖项
     */
    public getOptions(callback: Function): void {
        const net: INetData = {
            name: NetName.GAME_OPTIONS,
            uri: '/ngapi/getOptions',
            type: 'post',
            dataType: 'json',
            param: {
                id: DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     *  获取规则
     */
    public getRule(callback: Function): void {
        const net: INetData = {
            name: NetName.GAME_RULE,
            uri: '/ngapi/getRule',
            type: 'post',
            dataType: 'html',
            param: {
                id: DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 实时排行榜
     * @param {number} type 0总排行榜 1今日排行榜 2 多游戏总排行榜 3 昨日排行榜
     * @param {number} count 返回榜单长度 最大50
     */
    public realtimerank(callback: Function, type: number, count = 50): void {
        const net: INetData = {
            name: NetName.GAME_REAL_TIME_RANK,
            uri: '/ngapi/realtimerank',
            type: 'get',
            dataType: 'json',
            param: {
                id: DataManager.ins.gameCfgData.gameInfo.gameId,
                count: count,
            },
            callback: callback,
            addUrl: '/' + type
        };
        this.send(net);
    }

    /**
     * 获取成长值
     * @param {number} gametotalid 游戏中心榜单ID
     */
    public getUserTotalScore(callback: Function, gametotalid: number): void {
        const net: INetData = {
            name: NetName.GAME_TOTAL_SCORE,
            uri: '/ngapi/getUserTotalScore',
            type: 'get',
            dataType: 'json',
            param: {
                id: gametotalid
            },
            callback: callback
        };
        this.send(net);
    }

    //--------------------------------------------插件-----------------------------------------

    /**
     * 插件抽奖
     * @param {number} activityId 插件ID
     */
    public doJoinPlugDraw(callback: Function, activityId: number, deductCredits?: boolean): void {
        const net: INetData = {
            name: NetName.PLUG_DO_JOIN,
            uri: '/activityPlugDrawInfo/doJoinPlugdraw',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                deductCredits: deductCredits ? deductCredits : false
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 查询插件抽奖订单
     * @param {number} orderId 订单ID
     * @param {number} prizeLevel 开奖等级，暂未开放
     */
    public getPlugOrderStatus(callback: Function, orderId: number, pollingCheck: Function, pollingCount = 12, prizeLevel?: number): void {
        const net: INetData = {
            name: NetName.PLUG_ORDER_STATUS,
            uri: '/plugin/getOrderStatus',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    }
    public getPlugOrderStatus1(callback: Function, orderId: number, pollingCheck: Function, pollingCount = 12, prizeLevel?: number): void {
        const net: INetData = {
            name: 'getPlugOrderStatus1',
            uri: '/plugin/getOrderStatus',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    }

    public getPlugOrderStatus2(callback: Function, orderId: number, pollingCheck: Function, pollingCount = 12, prizeLevel?: number): void {
        const net: INetData = {
            name: 'getPlugOrderStatus2',
            uri: '/plugin/getOrderStatus',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    }

    /**
     * 查询插件信息
     * @param {string} orderId 订单ID
     */
    public getPrizeInfo(callback: Function, plugId: number): void {
        const net: INetData = {
            name: NetName.PLUG_PRIZE_INFO,
            uri: '/activityPlugDrawInfo/getPrizeInfo',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: plugId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 插件-批量查询奖项信息
     * @param {string} ids 插件ID 用，间隔
     */
    public optionInfo(callback: Function, ids: string): void {
        const net: INetData = {
            name: NetName.PLUG_OPTION_INFO,
            uri: '/activityPlugin/optionInfo',
            type: 'get',
            dataType: 'json',
            param: {
                ids: ids
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 插件校验解锁纪录
     * @param {number} id 插件ID
     */
    public unblocking(callback: Function, id: number): void {
        const net: INetData = {
            name: NetName.PLUG_UNBLOCKING,
            uri: 'activityPlugin/unblocking',
            type: 'post',
            dataType: 'json',
            param: {
                id: id
            },
            callback: callback
        };
        this.send(net);
    }

    //--------------------------------------------自定义活动工具-----------------------------------------

    /**
     * 获取基础信息
     */
    public ajaxElement(callback: Function): void {
        const net: INetData = {
            name: NetName.CUSTOM_ELEMENT,
            uri: '/hdtool/recon/ajaxElement',
            type: 'get',
            dataType: 'json',
            param: {
                duibaId: DataManager.ins.customCfgData.hdToolId,
                activityId: DataManager.ins.customCfgData.actId,
            },
            callback: callback
        };
        this.send(net);
    }

    public getRemainingTimes() {
        return new Promise((r) => {
            const net: INetData = {
                name: 'getRemainingTimes',
                uri: '/hdtool/esports/wordcollect/getRemainingTimes',
                type: 'get',
                dataType: 'json',
                param: {
                    activityId: DataManager.ins.customCfgData.actId,
                },
                callback: r
            };
            this.send(net);
        })

    }

    public getMusicCategory(callback: Function, categoryID?: number, categoryCode?, liteVersion?): void {
        const data: any = {};
        if (categoryID) data.categoryID = categoryID;
        if (categoryCode) data.categoryCode = categoryCode;
        if (liteVersion) data.liteVersion = liteVersion;
        const net: INetData = {
            name: 'getMusicCategory',
            uri: '/aaw/music/category',
            type: 'get',
            dataType: 'json',
            param: data,
            callback: callback
        };
        this.send(net);
    }

    public reportMusic(callback: Function, durationOfPlay, songListId, songId, playCount, timestamp, bitrate, songDuration): void {
        const data: any = {
            durationOfPlay: durationOfPlay, songListId: songListId, songId: songId, timestamp: timestamp,
            action: 7,
            playCount: playCount,
            bitrate: bitrate,
            isOnline: 1, songDuration: songDuration

        };
        // if (categoryID) data.categoryID = categoryID;
        const net: INetData = {
            name: 'reportMusic',
            uri: '/aaw/music/report',
            type: 'post',
            dataType: 'json',
            param: data,
            callback: callback
        };
        this.send(net);
    }

    public getMusicItem(callback: Function, songListId, itemId): void {
        const data: any = {};
        if (itemId) data.itemId = itemId;
        if (songListId) data.songListId = songListId;
        const net: INetData = {
            name: 'getMusicItem',
            uri: '/aaw/music/item',
            type: 'get',
            dataType: 'json',
            param: data,
            callback: callback
        };
        this.send(net);
    }

    public recentRankListNew(callback: Function, rankId): void {
        const net: INetData = {
            name: 'recentRankListNew',
            uri: '/hdtool/rank/recentRankListNew',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: DataManager.ins.customCfgData.actId,
                rankId: rankId,
                needPreviousPeriod: false,
                pageNo: 0,
                pageSize: 50
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 查询闯关游戏 配置信息
     * @param {number} throughId
     */
    public ajaxThroughInfo(callback: Function, throughId = 1): void {
        const net: INetData = {
            name: NetName.CUSTOM_THROUGH_INFO,
            uri: window['CFG'].ajaxThroughInfo,
            type: 'post',
            dataType: 'json',
            param: {
                hdtoolId: DataManager.ins.customCfgData.hdToolId,
                throughId: 1
            },
            callback: callback
        };
        this.send(net);
    }

    public doJoin(callback: Function, credits?: number, collectRuleId?: number): void {
        const param: any = {
            activityId: DataManager.ins.customCfgData.actId,
            activityType: 'hdtool',
            consumerId: window['CFG'].consumerId
        };
        if (credits) {
            param.credits = credits;
        }
        if (collectRuleId) {
            param.collectRuleId = collectRuleId;
        }
        const net: INetData = {
            name: 'dojoin',
            uri: '/hdtool/recon/doJoin',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.getToken(net);
    }

    public getUserShareCode(callback: Function): void {
        const param: any = {
            activityId: DataManager.ins.customCfgData.actId,
            activityType: 'hdtool',
        };
        const net: INetData = {
            name: 'getUserShareCode',
            uri: '/activtyShareCode/getUserShareCode',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    public yyh_recentlyGetJoinTimes(callback: Function): void {
        const param: any = {
            activityId: DataManager.ins.customCfgData.actId,
            isReset: true
        };
        const net: INetData = {
            name: 'yyh_recentlyGetJoinTimes',
            uri: '/customActivity/esports/recentlyGetJoinTimes',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    public yyh_getInviteRecords() {
        return new Promise((r) => {
            const param: any = {
                activityId: DataManager.ins.customCfgData.actId,
                pageNo: 1,
                pageSize: 200
            };
            const net: INetData = {
                name: 'yyh_getInviteRecords',
                uri: '/customActivity/esports/getInviteRecords',
                type: 'get',
                dataType: 'json',
                param: param,
                callback: r
            };
            this.send(net);
        })
    }

    public yyh_getRecord(origins) {
        return new Promise((r) => {
            const param: any = {
                page: 1,
                pageSize: 500,
                origins: origins
            };
            const net: INetData = {
                name: 'yyh_getRecord',
                uri: '/crecord/getrecord',
                type: 'get',
                dataType: 'json',
                param: param,
                callback: r
            };
            this.send(net);
        })
    }

    public yyh_doJoin(callback: Function): void {
        const param: any = {
            activityId: DataManager.ins.customCfgData.actId,
            activityType: 'hdtool',
            consumerId: window['CFG'].consumerId
        };
        const net: INetData = {
            name: 'yyh_doJoin',
            uri: '/hdtool/esports/wordcollect/dojoin',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.getToken(net);
    }

    public yyh_weOrder(callback: Function): void {
        const userInfo = DataManager.ins.getData('getProjectUserInfo').data;
        const param: any = {
            appId: window['appId'],
            uid: userInfo.partnerUserId,
            rowId: 1,
            max: 200
        };
        const net: INetData = {
            name: 'yyh_weOrder',
            uri: '/duiba/weOrder?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }
    public yyh_queryPrize(callback: Function): void {
        const param: any = {};
        const net: INetData = {
            name: 'yyh_queryPrize',
            uri: '/projectx/' + window['projectID'] + '/prize.query?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    public yyh_queryProjectRule(callback: Function): void {
        const param: any = {
        };
        const net: INetData = {
            name: 'yyh_queryProjectRule',
            uri: '/projectx/' + window['projectID'] + '/projectRule.query?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    public yyh_queryMyJoin(callback: Function): void {
        const param: any = {};
        const net: INetData = {
            name: 'yyh_queryMyJoin',
            uri: '/projectx/' + window['projectID'] + '/join_1/queryMyJoin.do?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    //领养
    public yyh_join_1_join(callback: Function): void {
        const param: any = {};
        const net: INetData = {
            name: 'yyh_join_1_join',
            uri: '/projectx/' + window['projectID'] + '/join_1/join.do?_=' + new Date().getTime(),
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    // if (window['getPxToken']) {
    //     window['getPxToken'](function (e, token) {
    //         switch (e) {
    //             case 'net error':
    //                 next('error', { type: 'error' });
    //                 break;
    //             case 'need login':
    //                 next('failed', { type: 'failed' });
    //                 break;
    //             case 'state invalid':
    //                 next('invalid', { type: 'invalid' });
    //                 break;
    //             default:
    //                 if (token) {
    //                     scope.token = token;
    //                     next('success', args);
    //                 }
    //                 else {
    //                     next('invalid', { type: 'invalid key' });
    //                 }
    //         }
    //     });
    // }
    // else {
    //     next('error', { type: 'no ready' });
    // }


    public getPxToken(net: INetData): void {
        if (window['getPxToken']) {
            window['getPxToken']((e, token: any) => {
                if (e)
                    this.onError(net);
                else {
                    net.param.token = token;
                    this.send(net);
                }
            });
        } else {
            this.send(net);
        }
    }

    //签到
    public yyh_dosign(callback: Function): void {
        const timestamp = new Date().getTime();
        const param: any = {    };
        // const param: any = {
        //     //校验token：md5(timestamp + "duiba4hefeicmbchina")
        //     timestamp: timestamp,
        //     token: window['duiba_md5'](timestamp + "duiba4hefeicmbchina")
        // };
        const net: INetData = {
            name: 'yyh_dosign',
            uri: '/projectx/' + window['projectID'] + '/join_2/join.do?_=' + new Date().getTime(),
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.getPxToken(net);
    }
    // public yyh_dosign(callback: Function): void {
    //     const timestamp = new Date().getTime();
    //     const param: any = {
    //         //校验token：md5(timestamp + "duiba4hefeicmbchina")
    //         timestamp: timestamp,
    //         token: window['duiba_md5'](timestamp + "duiba4hefeicmbchina")
    //     };
    //     const net: INetData = {
    //         name: 'yyh_dosign',
    //         uri: '/projectx/' + window['projectID'] + '/join_2/join.do?_=' + new Date().getTime(),
    //         type: 'post',
    //         dataType: 'json',
    //         param: param,
    //         callback: callback,
    //         hideMsg: true
    //     };
    //     this.send(net);
    // }

    //签到信息
    public yyh_signInfo(callback: Function): void {
        const param: any = {};
        const net: INetData = {
            name: 'yyh_signInfo',
            uri: '/projectx/' + window['projectID'] + '/join_2/signInfo.do?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    //答题 answer从0开始
    public yyh_doAnswer(callback: Function, questionId, answer: number): void {
        const param: any = {
            questionId: questionId,
            answer: answer
        };
        const net: INetData = {
            name: 'yyh_doAnswer',
            uri: '/projectx/' + window['projectID'] + '/join_3/join.do?_=' + new Date().getTime(),
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }
    public yyh_questionInfo(callback: Function): void {
        const param: any = {};
        const net: INetData = {
            name: 'yyh_questionInfo',
            uri: '/projectx/' + window['projectID'] + '/join_3/questionInfo.do?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }
    public yyh_doTask(callback: Function, taskId): void {
        const param: any = { taskId: taskId };
        const net: INetData = {
            name: 'yyh_doTask',
            uri: '/projectx/' + window['projectID'] + '/join_4/join.do?_=' + new Date().getTime(),
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }
    public yyh_taskInfo(callback: Function): void {
        const param: any = {};
        const net: INetData = {
            name: 'yyh_taskInfo',
            uri: '/projectx/' + window['projectID'] + '/join_4/taskInfo.do?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }
    public yyh_doBind(callback: Function, recommendCode): void {
        const param: any = { recommendCode: recommendCode };
        const net: INetData = {
            name: 'yyh_doBind',
            uri: '/projectx/' + window['projectID'] + '/join_5/join.do?_=' + new Date().getTime(),
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }
    public yyh_bindInfo(callback: Function): void {
        const param: any = {};
        const net: INetData = {
            name: 'yyh_bindInfo',
            uri: '/projectx/' + window['projectID'] + '/join_5/bindInfo.do?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    public yyh_index(callback: Function): void {
        const param: any = {

        };
        const net: INetData = {
            name: 'yyh_index',
            uri: '/projectx/' + window['projectID'] + '/join_1/join.do?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    public getProjectUserInfo(callback: Function): void {
        const param: any = {

        };
        const net: INetData = {
            name: 'getProjectUserInfo',
            uri: '/ctool/getProjectUserInfo?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    // 获取商品列表
    public getExchangeList(callback: Function, classifyId: number = window["classifyId"]): void {
        const param: any = {
            classifyId: classifyId
        };
        const net: INetData = {
            name: 'getExchangeList',
            uri: '/chw/visual-editor/items/list?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    // 登录授权
    public getLoginInfo(callback: Function): void {
        const param: any = {

        };
        const net: INetData = {
            name: 'getLoginInfo',
            uri: '/customActivity/cmbbank/hefei/merchantLoginInfo?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    // 获取免登链接
    public getAutoLoginUrl(callback: Function, body: any, redirectUrl: string = window["redirectUrl"]): void {
        console.log(body)
        const param: any = {
            redirectUrl: redirectUrl,
            body: body.body
        };
        const net: INetData = {
            name: 'getAutoLoginUrl',
            uri: '/customActivity/cmbbank/hefei/autoLogin?_=' + new Date().getTime(),
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }


    public yyh_receivingGifts(callback: Function): void {
        const param: any = {
            activityId: DataManager.ins.customCfgData.actId
        };
        const net: INetData = {
            name: 'yyh_receivingGifts',
            uri: '/hdtool/esports/wordcollect/receivingGifts',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    }

    public getNgameStartStatus(callback: Function, orderId: number, pollingCheck: Function, pollingCount = 10): void {
        const param: any = {
            orderId: orderId
        };
        const net: INetData = {
            name: 'getNgameStartStatus',
            uri: '/hdtool/recon/ngame/getNgameStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    }

    /**
     * 活动工具查询订单结果
     * @param orderId
     */
    public getCustomOrderStatus(callback: Function, orderId: number, pollingCheck: Function, pollingCount = 5): void {
        const net: INetData = {
            name: NetName.CUSTOM_ORDER_STATUS,
            uri: window['CFG'].quireOrder,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    }

    /**
     * 获取抽奖前置信息
     * @param {string} orderId 订单ID
     */
    public getOrderInfo(callback: Function, orderId: number, showMsg = true): void {
        const net: INetData = {
            name: NetName.CUSTOM_ORDER_INFO,
            uri: window['CFG'].gameGetOrder,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    }

    /**
     * 前置开奖提交
     * @param {string} orderId 订单ID
     * @param {string} facePrice 前置开奖所需分值
     */
    public beforSubmit(callback: Function, orderId: number, facePrice: number): void {
        const net: INetData = {
            name: NetName.CUSTOM_BEFOR_SUBMIT,
            uri: window['CFG'].gameSubmit,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId,
                facePrice: facePrice
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 答题提交
     */
    public questionSubmit(): void {

    }

    /**
     * 闯关游戏提交
     */
    public throughSubmit(callback: Function, orderId: number): void {
        const net: INetData = {
            name: NetName.CUSTOM_THROUGH_SUBMIT,
            uri: window['CFG'].throughSubmit,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback
        };
        this.send(net);
    }

    //--------------------------------------------养成-----------------------------------------

    /**
     * 宠物领养
     * @param {number} activityId 宠物养成活动ID
     */
    public petAdopte(callback: Function, activityId: number): void {
        const net: INetData = {
            name: NetName.PET_ADOPTE,
            uri: '/signpet/adopte',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 宠物状态刷新
     * @param {number} petId 宠物ID
     */
    public getPetStatus(callback: Function, petId: number): void {
        const net: INetData = {
            name: NetName.PET_STATUS,
            uri: '/signpet/status',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 宠物喂食
     * @param {number} petId 宠物ID
     * @param {number} feedNum 喂食数量
     */
    public petFeed(callback: Function, petId: number, feedNum: number): void {
        const net: INetData = {
            name: NetName.PET_FEED,
            uri: '/signpet/feed',
            type: 'post',
            dataType: 'json',
            param: {
                petId: petId,
                feedNum: feedNum
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 获取宠物信息
     * @param callback 
     * @param activityId 
     */
    public getPetInfo(callback: Function, activityId: number): void {
        const net: INetData = {
            name: NetName.PET_INFO,
            uri: '/signpet/getPetInfo',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 签到信息查询
     * @param {Function} callback
     * @param {number} signActivityId 签到活动ID
     */
    public getSignInfo(callback: Function, signActivityId: number): void {
        const net: INetData = {
            name: NetName.SIGN_INFO,
            uri: '/signactivity/getSignInfo',
            type: 'post',
            dataType: 'json',
            param: {
                signActivityId: signActivityId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 签到接口
     * @param {Function} callback
     * @param {number} signActivityId 签到活动ID
     * @param {number} activityId 插件活动ID，用于加抽奖次数，不传则使用签到身上配置的插件活动ID，否则不加抽奖次数
     */
    public doSign(callback: Function, signActivityId: number, activityId: number): void {
        const net: INetData = {
            name: NetName.SIGN_DO_SIGN,
            uri: '/signactivity/doSign',
            type: 'post',
            dataType: 'json',
            param: {
                id: signActivityId,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 道具展示接口
     * @param callback 
     * @param {number} actId 宠物活动ID
     */
    public getToys(callback: Function, actId: number): void {
        const net: INetData = {
            name: NetName.PET_TOYS,
            uri: '/signpet/addition/getToys',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 道具兑换接口
     * @param callback 
     * @param {number} toyId 道具id
     * @param {number} credits 兑换所需积分
     */
    public toyExchange(callback: Function, toyId: number, credits: number): void {
        const net: INetData = {
            name: NetName.PET_TOY_EXCHANGE,
            uri: '/signpet/addition/toyExchange',
            type: 'post',
            dataType: 'json',
            param: {
                toyId: toyId,
                credits: credits
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 道具使用接口
     * @param callback 
     * @param {string} identifier 道具唯一标识
     * @param {number} petId 宠物id
     */
    public toyUse(callback: Function, identifier: string, petId: number): void {
        const net: INetData = {
            name: NetName.PET_TOY_USE,
            uri: '/signpet/addition/toyUse',
            type: 'post',
            dataType: 'json',
            param: {
                identifier: identifier,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 收取礼物接口
     * @param callback 
     * @param {number} giftId 礼物id
     * @param {string} giftName 礼物名称
     * @param {string} giftDesc 礼物描述
     * @param {number} giftType 礼物类型 1：用户自定义， 2：食物
     * @param {string} giftLink 礼物链接
     * @param {number} petId 宠物id
     */
    public collect(callback: Function,
        giftId: number,
        giftNum: number,
        giftName: string,
        giftDesc: string,
        giftType: number,
        giftLink: string,
        petId: number): void {
        const net: INetData = {
            name: NetName.PET_COLLECT,
            uri: '/signpet/addition/collect',
            type: 'post',
            dataType: 'json',
            param: {
                giftId: giftId,
                giftNum: giftNum,
                giftName: giftName,
                giftDesc: giftDesc,
                giftType: giftType,
                giftLink: giftLink,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 群内喂食排行榜
     * @param callback 
     * @param {number} petId 宠物id
     * @param {number} topNum 排行榜显示top个数
     */
    public getRankList(callback: Function, petId: number, topNum: number, pollingCheck: Function, pollingCount?: number): void {
        const net: INetData = {
            name: NetName.PET_GET_RANK_LIST,
            uri: '/signpet/getRankList',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId,
                topNum: topNum,
                pollingCheck: pollingCheck,
                pollingCount: pollingCount
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 查询待领取粮食
     * @param callback 
     */
    public getFoodPiles(callback: Function): void {
        const net: INetData = {
            name: NetName.PET_GET_FOOD_PILES,
            uri: '/signpet/getFoodPiles',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    }

    /**
     * 待领取粮食收取
     * @param callback 
     * @param {number} id 待领取粮食主键ID
     * @param {number} activityId 活动id
     */
    public collectFood(callback: Function, id: number, activityId: number): void {
        const net: INetData = {
            name: NetName.PET_COLLECT_FOOD,
            uri: '/signpet/collectFood',
            type: 'post',
            dataType: 'json',
            param: {
                id: id,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    }

    //--------------------------------------------------------------------外来宠物养成--------------------------------------------------------------------------
    /**
     * 活动主信息接口
     * @param callback 
     * @param activityId 
     */
    public getHomeInfo(callback: Function, activityId: number): void {
        const net: INetData = {
            name: NetName.PETS_GET_HOME_INFO,
            uri: '/sign/wander/getHomeInfo',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 商店道具接口
     * @param callback 
     * @param actId 
     * @param actType 	2-日历 4-养成 5-契约 6-外来宠物
     * @param toyType   1-状态 2-装饰 3-功能 4-食物 5-玩具
     */
    public getActToys(callback: Function, actId: number, actType: number, toyType: number): void {
        const net: INetData = {
            name: NetName.PETS_GET_ACT_TOYS,
            uri: '/sign/addition/getActToys',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId,
                actType: actType,
                toyType: toyType
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 外来宠物养成-道具兑换接口
     * @param callback 
     * @param {number} toyId 道具id
     */
    public toyExchanges(callback: Function, toyId: number): void {
        const net: INetData = {
            name: NetName.PETS_TOY_EXCHANGE,
            uri: '/sign/addition/toyExchange',
            type: 'post',
            dataType: 'json',
            param: {
                toyId: toyId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 道具使用接口
     * @param callback 
     * @param {number} actId 活动id
     * @param {any[]} toyList 使用的道具列表 [{identifier:'道具标识', position:'投放位置'}, {identifier:'道具标识', position:'投放位置'}]
     */
    public useToy(callback: Function, actId: number, toyList: any[]): void {
        const net: INetData = {
            name: NetName.PETS_USE_TOYS,
            uri: '/sign/addition/useToy',
            type: 'post',
            dataType: 'json',
            param: {
                actId: actId,
                toyList: JSON.stringify(toyList)
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 已购买的道具接口
     * @param callback 
     * @param petId     宠物id 没有传0
     * @param toyType   1-状态 2-装饰 3-功能 4-食物 5-玩具
     */
    public getUserToys(callback: Function, petId: number, toyType: number): void {
        const net: INetData = {
            name: NetName.PETS_GET_USER_TOYS,
            uri: '/sign/addition/getUserToys',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId,
                toyType: toyType
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 粮食收取
     * @param callback 
     * @param actId     活动id
     * @param ids       收取粮食堆的主键id列表[1,2,3,4]
     */
    public batchollectFood(callback: Function, actId: number, ids: number[]): void {
        const net: INetData = {
            name: NetName.PETS_BATCHOLLECT_FOOD,
            uri: '/sign/addition/batchollectFood',
            type: 'post',
            dataType: 'json',
            param: {
                ids: JSON.stringify(ids),
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 来访统计
     * @param callback 
     * @param actId 
     */
    public visitStatistics(callback: Function, actId: number): void {
        const net: INetData = {
            name: NetName.PETS_VISI_STATISTICS,
            uri: '/sign/wander/visitStatistics',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 动态信息列表
     * @param callback 
     * @param actId         活动id
     * @param showNum       显示条数
     */
    public getVisitInfo(callback: Function, actId: number, showNum: number): void {
        const net: INetData = {
            name: NetName.PETS_GET_VISIT_INFO,
            uri: '/sign/wander/getVisitInfo',
            type: 'get',
            dataType: 'json',
            param: {
                showNum: showNum,
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 到访记录详情
     * @param callback 
     * @param actId ：活动id
     * @param identifier ：宠物唯一标识
     */
    public visitDetail(callback: Function, actId: number, identifier: string): void {
        const net: INetData = {
            name: NetName.PETS_VISIT_DETAIL,
            uri: '/sign/wander/visitDetail',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId,
                identifier: identifier
            },
            callback: callback
        };
        this.send(net);
    }

    /**
     * 礼物收取
     * @param callback 
     * @param recordId 礼物记录ID
     */
    public collectGiftRecord(recordId: number, callback: Function): void {
        const net: INetData = {
            name: NetName.PETS_COLLECT_GIFT_RECORD,
            uri: '/sign/wander/collectGiftRecord',
            type: 'post',
            dataType: 'json',
            param: {
                recordId: recordId
            },
            callback: callback
        };
        this.send(net);
    }


    /**
     * 获取token
     * @param net 
     */
    public getToken(net: INetData): void {
        if (window['getDuibaToken']) {
            window['getDuibaToken']((tokenObj: any) => {
                net.param.token = tokenObj.token;
                this.send(net);
            }, (key: string, messageObj: any) => {
                this.onError(net);
            });
        } else {
            this.send(net);
        }
    }

    /**
     * 查询我的奖品记录
     * @param callback 
     * @param {number} page 当前页数
     */
    public getRecord(callback: Function, page: number): void {
        const net: INetData = {
            name: NetName.GET_RECORD,
            uri: (window['recordUrl'] ? window['recordUrl'] : '') + '/Crecord/getRecord',
            type: 'get',
            dataType: 'json',
            param: {
                page: page
            },
            callback: callback
        };

        let gTime: string = '?_=' + GTime.getTimestamp();
        let realUrl: string = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime.getTimestamp();
        }

        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }

        window['$'].ajax({
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            xhrFields: {
                withCredentials: true
            },
            crossDomain: true,
            cache: false,
            success: (result) => {
                this.onResponse(net, result);
            },
            error: (message) => {
                this.onError(net);
            }
        });
    }

    /**
     * 推啊曝光埋点(福袋)
     * @param {IExposureData} exposure
     */
    public spmshow(exposure: IExposureData): void {
        const domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        const net: INetData = {
            name: 'spmshow',
            uri: domain + 'spmshow',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    }

    /**
     * 推啊点击埋点(福袋)
     * @param {IExposureData} exposure
     */
    public spmclick(exposure: IExposureData): void {
        const domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        const net: INetData = {
            name: 'spmclick',
            uri: domain + 'spmclick',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    }

    /**
     * 兑吧点击埋点
     * @param {IExposureData} exposure
     */
    public clickLog(exposure: IExposureData): void {
        const net: INetData = {
            name: 'clickLog',
            uri: '/log/click',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    }

    /**
     * 兑吧曝光埋点
     * @param {IExposureData} exposure
     */
    public showLog(exposure: IExposureData): void {
        const net: INetData = {
            name: 'showLog',
            uri: exposure.domain + '/exposure/standard',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    }

    /**
      * 消息响应
      * @param net 
      * @param result 结果
      */
    protected onResponse(net: INetData, result: any): void {
        //数据处理
        const data: Data = DataManager.ins.updateData(net.name, result, net.param);
        //接口成功
        if (net.pollingCount && net.pollingCheck(data)) {
            net.pollingCount -= 1;
            //轮询接口特殊处理
            setTimeout(() => {
                this.send(net);
            }, 500);
        } else if (net.callback) {
            if (net.pollingCheck && net.pollingCount == 0 && net.pollingCheck(data)) {
                result.message = '系统异常，请稍后再试。';
                data['success'] = false;
            }
            net.callback(data.success, data || result);
        }
        if (!data.success && !net.hideMsg) {
            GDispatcher.dispatchEvent(ABNetManager.ERROR, net, result.message || result.desc || result.msg);
        }
        if (!data.success && !net.hideMsg) {
            onNotSuccess(data, net.name)
        }
    }

    // onNotSuccess: Function;

    /**
     * 通讯底层错误
     * @param net 
     * @param message 
     */
    protected onError(net: INetData): void {
        if (net.callback) {
            net.callback(false);
        }

        if (!net.hideMsg) {
            GDispatcher.dispatchEvent(ABNetManager.ERROR, net);
            onNotSuccess();
        }
    }
    // tslint:disable-next-line:max-file-line-count
}