import getSkinPath from "../utils/getSkinPath";
export default class ComponentBase extends eui.Component {
    protected data: any;
    constructor() {
        super();
        this.data = {};
    }

    loadSkin() {
        this.skinName = getSkinPath(this.skinKey);
        if (this.skin) {
            this.onSkinComplete();
        } else {
            this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        }
    }

    protected initEvents() { }

    protected removeEvents() { }

    start(data?) {
        this.initEvents();
    }

    get skinKey():string { return null }
    get resKey():string { return null }

    protected onSkinComplete() {
        
    }

    destroy() {
        this.removeEvents();
    }

}