import ComponentBase from "../Components/ComponentBase";
import Loading from "../Loading/Loading";
import IScene from "../Components/IScene";
import { Decorator } from "../Decorator/Decorator";

@Decorator.ClassName("clsNamne123")
export default class Scene extends ComponentBase {
    public set onLoaded(v: () => void) {
        if (this.loadedOnConstruct) {
            v();
        } else {
            this._onLoaded = v;
        }
    }
    public get onLoaded() {
        return this._onLoaded;
    }
    private _onLoaded: () => void = null;
    public loadedOnConstruct = false;

    constructor(data?:any) {
        super(data);
        if (this.skin) {
            this.loadedOnConstruct = true;
        } else {
            this.addEventListener(eui.UIEvent.COMPLETE, () => {
                this.onLoaded && this.onLoaded();
            }, this);
        }
    }
}