import Loading from "../Loading/Loading";
import IScene from "../components/IScene";
import Scene from "../views/Scene";

export default class SceneCtrl {
    public get parent(): eui.Group {
        return this._parent;
    }
    private _parent: eui.Group;
    private _currentScene: Scene;

    static _instance: SceneCtrl;
    static get instance() {
        return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl())
    }
    init(parent: eui.Group) {
        this._parent = parent;
    }

    change(cls: any, data?: any) {
        let scene: Scene = new cls(data);

        if (this._currentScene) {
            let preScene = this._currentScene;
            scene.visible = false;
            scene.onLoaded = () => {
                preScene.destroy();
                scene.visible = true;
            }
        }

        this._currentScene = scene;
        this._parent.addChild(scene);
    }
}