import Panel from "../views/Panel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";

@Decorator.ClassName("RewardPanel")
export default class RewardPanel extends Panel {
    public btnView: MButton;
    public img: eui.Image;
    public btnClose: MButton;

    data: {
        imgUrl: string,
        rewardUrl: string
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.img.source = this.data.imgUrl;
        this.btnView.onTap(this, () => {
            this.hidePanel();
            window.location.href = this.data.rewardUrl;
        });
        this.btnClose.onTap(this, () => this.hidePanel());
    }

}