import Panel from "../views/Panel";
import MButton from "../MUI/MButton";
import { Decorator } from "../Decorator/Decorator";

@Decorator.ClassName("CommonPanel")
export default class CommonPanel extends Panel {
    public btnClose: MButton;
    public titleShadow: eui.Label;
    public title: eui.Label;
    public labelContent: eui.Label;
    public btnOk: MButton;
    public tip: eui.Label;

    data: {
        title: string,
        content: string,
        btnLabel: string,
        tip?: string,
        btnEvent?: (context?: CommonPanel) => void;
    }

    onSkinComplete() {
        super.onSkinComplete();

        this.btnClose.onTap(this, () => this.hidePanel());
        if (typeof this.data.btnEvent == "function") {
            this.btnOk.onTap(this, () => {
                this.data.btnEvent(this);
            });
        } else {
            this.btnOk.onTap(this, () => this.hidePanel());
        }

        this.btnOk.label = this.data.btnLabel;
        this.tip.text = this.data.tip || "";
        this.titleShadow.text = this.data.title;
        this.title.text = this.data.title;
        this.labelContent.text = this.data.content;
    }
}