import PhycicsSystem from "../Game/PhycicsSystem";
import MTweenMgr from "../components/MTween";
import SoundMgr from "./SoundMgr";
import GuideMask from "../Panel/GuideMask";
import SceneCtrl from "../Ctrls/SceneCtrl";
import MainScene from "../Scene/MainScene";

export default class GameMgr {
    private static _instance: GameMgr = null;
    public static get instance(): GameMgr {
        if (!this._instance) {
            this._instance = new GameMgr();
        }

        return this._instance;
    }

    public hasSetMusic: boolean = false;

    private _pause: boolean = false;
    public set pause(v: boolean) {
        this._pause = v;
        PhycicsSystem.instance.pause = this._pause;
        MTweenMgr.instance.pause = this._pause;
    }
    public get pause() {
        return this._pause;
    }

    private mainScene: MainScene = null;
    init(mainScene: MainScene) {
        this.mainScene = mainScene;
        this.pause = false;
    }

    public switchSound() {
        SoundMgr.instance.musicEnabled = !SoundMgr.instance.musicEnabled;
        SoundMgr.instance.effectEnabled = !SoundMgr.instance.effectEnabled;
    }

    public minEnableCaptchaScore: number = null;
    public leftTimes: number = null;
    public leftInviteCnt: number = null;
    public allPeriodEnd: number = null;
    public assistItemId: number = null;

    public get guideFlag(): boolean {
        return localStorage.getItem("guide") != "false";
    }
    public set guideFlag(v: boolean) {
        localStorage.setItem("guide", v ? "true" : "false");
    }
    private currentGuideMask: GuideMask = null;
    public runGuide(index: number, x: number, y: number, end: boolean = false) {
        this.currentGuideMask && this.currentGuideMask.destroy(); // 销毁之前的实例
        this.currentGuideMask = new GuideMask(index, x, y);
        this.currentGuideMask.onClick = () => {
            this.currentGuideMask && this.currentGuideMask.destroy();
            this.mainScene.resume();

            if (end) {
                this.guideFlag = false;
            }
        };
        SceneCtrl.instance.parent.addChild(this.currentGuideMask);
        this.mainScene.pause();
    }



}