
const MinHeight = 1330;

export default class MLayers extends eui.UILayer {
    public sceneLayer: eui.Group = null;
    public popupLayer: eui.Group = null;
    public topLayer: eui.UILayer = new eui.UILayer();
    public toastLayer: eui.UILayer = new eui.UILayer();
    public scroller: eui.Scroller = null;

    private static _instance: MLayers = null;
    public static get instance(): MLayers {
        if (!this._instance) {
            this._instance = new MLayers();
        }

        return this._instance;
    }

    public setScroller(v: boolean) {
        if (this.scroller == null) return;
        if (v == true) {
            this.scroller.viewport = this;
        } else {
            this.scroller.viewport = null;
            this.scroller.addChild(this);
        }
    }

    init(root: eui.UILayer) {
        if (document.body.clientWidth / document.body.clientHeight > 750 / MinHeight) {
            let scroller = new eui.Scroller();
            this.scroller = scroller;
            root.addChild(scroller);
            scroller.viewport = this;
            scroller.bounces = false;
            scroller.addChild(this);
            this.popupLayer = new eui.Group();
            this.popupLayer.width = 750;
            this.popupLayer.height = MinHeight;
            this.sceneLayer = new eui.Group();
            this.sceneLayer.width = 750
            this.sceneLayer.height = MinHeight;
            this.addChild(this.sceneLayer);
            this.addChild(this.popupLayer);
        } else {
            root.addChild(this);
            this.popupLayer = new eui.UILayer();
            this.sceneLayer = new eui.UILayer();
            this.addChild(this.sceneLayer);
            this.addChild(this.popupLayer);
        }

        this.addChild(this.toastLayer);
        this.addChild(this.topLayer);


        this.popupLayer.visible = false;
        this.topLayer.visible = false;
        this.toastLayer.touchEnabled = false;
    }
}