import MSVGAClip from "./MSVGAClip";
import SpTimer from "../Game/SpTimer";

let lastTime = 0;
let curTime = 0;
function updateDeltaTime() {
    lastTime = curTime;
    curTime = egret.getTimer();
    SpTimer.deltaTime = curTime - lastTime;
}

// let deltaTimeBeforPause: number;
export function customClassPrototype() {
    egret.EventDispatcher.prototype.onTap = function (target: any, callback: () => void) {
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, callback, target);
    }

    egret.DisplayObject.prototype.destroy = function () {
        if (this.parent) {
            this.parent.removeChild(this);
        }
    }

    String.prototype.isLowerCase = function (this: string) {
        if (this.length != 1) return false;
        return this >= 'A' && this <= 'Z';
    }

    String.prototype.isUpperCase = function (this: string) {
        if (this.length != 1) return false;
        return this >= 'A' && this <= 'Z';
    }

    Math.clamp = function (target: number, min: number, max: number) {
        if (target > max) target = max;
        if (target < min) target = min;
        return target;
    }

    egret.MainContext.instance.stage.addEventListener(egret.Event.ENTER_FRAME, updateDeltaTime, null);
    egret.lifecycle.onResume = () => {
        curTime = egret.getTimer();
    }
}