import Panel from "../views/Panel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import SceneCtrl from "../Ctrls/SceneCtrl";
import StartScene from "../Scene/StartScene";
import MLabel from "../MUI/MLabel";
import Net from "../Global/Net";
import MainScene from "../Scene/MainScene";
import GameMgr from "../Mgr/GameMgr";
import ToastPanel from "../Components/ToastPanel";

@Decorator.ClassName("WinningPanel")
export default class WinningPanel extends Panel {
    public labelScore: MLabel;
    public labelHighestScore: MLabel;
    public btnClose: MButton;
    public btnRestart: MButton;


    data: {
        score: number,
        highestScore: number,
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.hidePanel();
            SceneCtrl.instance.change(StartScene);
        });
        this.labelScore.text = this.data.score.toString() + "/e分";
        let text = typeof this.data.highestScore == "number" ? this.data.highestScore.toString() + "/e分" : "-";
        this.labelHighestScore.text = text;

        this.btnRestart.onOnceTap(this, () => {
            this.hidePanel();
            SceneCtrl.instance.change(StartScene);
        });
    }
}