import Panel from "../views/Panel";
import { Decorator } from "../Decorator/Decorator";
import PropsItem from "./PropsItem";
import Net from "../Global/Net";
import MButton from "../MUI/MButton";

@Decorator.ClassName("MyPropsPanel")
export default class MyPropsPanel extends Panel {
    public dataGroup: eui.DataGroup;
    public btnClose: MButton;
    public labelNothing: eui.Label;

    async preLoadRes() {
        await super.preLoadRes();
        return RES.loadGroup("props");
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        Net.sendGet(Net.Url.queryProps, undefined, res => {
            let map = res.data.spMap;
            let arr = [];
            Object.keys(map).forEach(id => {
                if (map[id] > 0) {
                    arr.push({
                        id: id,
                        num: map[id],
                    });
                }
            });
            if (arr.length <= 0) {
                this.labelNothing.visible = true;
                this.dataGroup.visible = false;
                return;
            }
            this.dataGroup.dataProvider = new eui.ArrayCollection(arr);
            this.dataGroup.itemRenderer = PropsItem;
        });
    }
}