import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import ToastPanel from "../Components/ToastPanel";
import Loading from "../Loading/Loading";
import SceneCtrl from "../Ctrls/SceneCtrl";
import StartScene from "../Scene/StartScene";
import PanelCtrl from "../Ctrls/PanelCtrl";
import { NetUtils } from "./NetUtils";
import CommonPanel from "../Panel/CommonPanel";
import { Buried } from "../../libs/tw/util/Buried";

const projectId = NetUtils.getProjectId();
export default class Net {
    public static cache: object = {};

    /**
     * 
     * @param uri URL
     * @param param 参数
     * @param onSuccess 返回成功时的回调
     * @param onFail 返回失败是的回调 | 是否使用默认失败回调函数
     * @param pollingCheck 每次轮询回调
     * @param pollingCount 轮询最大次数
     */
    public static sendGet(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("get", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }

    /**
     * 
     * @param uri URL
     * @param param 参数
     * @param onSuccess 返回成功时的回调
     * @param onFail 返回失败是的回调 | 是否使用默认失败回调函数
     * @param pollingCheck 每次轮询回调
     * @param pollingCount 轮询最大次数
     */
    public static sendPost(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("post", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }

    private static mSend(type: string, uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        if (pollingCheck) {
            Loading.instace.show();
        }

        NetManager.ins.send({
            name: uri,
            uri: uri,
            type: type,
            dataType: 'json',
            param: param,
            callback: (success: any, res: any) => {
                Net.cache[uri] = res;

                if (pollingCheck) {
                    Loading.instace.hide();
                }

                if (success) {
                    console.log("response", uri, res);
                    onSuccess(res);
                } else {
                    console.warn("response", uri, res);

                    let errorMsg =
                        res && (
                            (
                                res["desc"] || res["message"]
                            )
                            || (
                                (
                                    res["code"] && "network error:" + res["code"]
                                )
                                || "network error"
                            )
                        )
                        || "network error";

                    if (typeof onFail == "function") {
                        if (!onFail(res)) { //若客户没有处理错误码，怎么默认显示错误消息或描述文字的弹窗
                            ToastPanel.show(errorMsg);
                        }
                    } else {
                        if (typeof onFail == "boolean" && onFail == true && typeof Net.defaultOnFail == "function") {
                            if (!Net.defaultOnFail(res)) {
                                ToastPanel.show(errorMsg);
                            }
                        }
                    }
                }
            },
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        });
        console.log("requset", uri, param);
    }

    public static defaultOnFail: (res: any) => boolean = () => {
        PanelCtrl.instance.closeAll();
        PanelCtrl.instance.show<CommonPanel>(class extends CommonPanel {
            onSkinComplete() {
                super.onSkinComplete();
                Buried.doShowBuried(7);
            }
        }).data = {
                title: "非常抱歉",
                content: "活动过于火爆\n前方拥挤\n请稍后再试",
                btnLabel: "我知道了",
                btnEvent: (context) => {
                    context.hidePanel();
                    Buried.doClickBuried(7);
                }
            }
        Loading.instace.hide();
        return true;
    }

    public static urlReplace() {
        for (let i of Object.keys(Net.Url)) {
            for (let j of Object.keys(Net.urlReplaceConfig)) {
                Net.Url[i] = Net.Url[i].replace(new RegExp(j, "g"), Net.urlReplaceConfig[j]);
            }
        }
    }

    private static urlReplaceConfig = {
        "{projectId}": projectId
    }

    public static readonly Url = {
        signIn: "",
        signData: "",
        queryProps: "",
        start: "/projectx/{projectId}/scoring_1/start.do",
        finalSubmit: "/projectx/{projectId}/scoring_1/submit.do",
        revive: "/projectx/{projectId}/scoring_1/revive.do",
        constantSubmit: "/projectx/{projectId}/scoring_1/push.do",
        rankList: "/projectx/{projectId}/join_1/data.do",
        queryRankListData: "/projectx/{projectId}/getRanking.query",
        queryNickname: "/projectx/{projectId}/join_1/userInfoList.do",
        visit: "/projectx/{projectId}/scoring_1/visit.do",
        taskData: "/projectx/{projectId}/join_2/data.do",
        taskComplete: "/projectx/{projectId}/join_2/join.do",
        shareData: "/projectx/{projectId}/assist_1/createItem.do",
        assist: "/projectx/{projectId}/assist_1/doAssist.do"
    }
}