// export const MConfigs: any = window;
export namespace MConfigs {
    export function updateConfig() {
        let mconfig = window["mconfig"];
        if (typeof mconfig != "object") return;

        Object.keys(mconfig).forEach(e => {
            MConfigs[e] = mconfig[e];
        });
    }

    export const size = [0.3125, 0.5357, 0.7321, 1];
    export const drop = {
        0: {
            type: "bullet",
            value: 1,
            textColor: 0x5dcefa,
            fileIndex: "0"
        },
        1: {
            type: "bullet",
            value: 2,
            textColor: 0x69e7fc,
            fileIndex: "1"
        },
        2: {
            type: "power",
            value: 30,
            textColor: 0xe83cf7,
            fileIndex: "2"
        },
        3: {
            type: "power",
            value: 20,
            textColor: 0xeb3924,
            fileIndex: "1"
        },
        4: {
            type: "power",
            value: 10,
            textColor: 0xfef552,
            fileIndex: "0"
        }
    }

    export const dropPool = {
        0: {
            num: 3,
            factor: {
                0: 40,
                1: 0,
                2: 0,
                3: 15,
                4: 50
            }
        },
        1: {
            num: 2,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        },
        2: {
            num: 1,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        }
    }

    export const props: {
        [key: string]: {
            id: string,
            name: string,
            img: string,
            color: number,
            disabledImg: string,
            index: number
        }
    } = {
        "sp_1": {
            index: 0,
            id: "sp_1",
            name: "1万分加分卡",
            img: "score_card_100_png",
            disabledImg: null,
            color: 0xf9b74b
        },
        "sp_2": {
            index: 1,
            id: "sp_2",
            name: "5万分加分卡",
            img: "score_card_500_png",
            disabledImg: null,
            color: 0xfe93df
        },
        "sp_3": {
            index: 2,
            id: "sp_11",
            name: "复活卡",
            img: "revive_card_png",
            disabledImg: "disabled_revive_card_png",
            color: 0x39c6e1
        }
    }

    export const selectPropsCountDown = 10;

    export const boomEffectColor = [
        0xe41014,
        0xff9600,
        0x0090ff,
        0x8aff00,
        0xffe720
    ]

    /**倒计时秒数 */
    export const countDown = 300;

    type TaskCode = "share" | "bindCard" | "mobilePay";
    export const task: {
        [key: string]: {
            taskCode: TaskCode,
            title: string,
            content: string,
            tip: string,
            url: string,
            name?: string
        }
    } = {
        "share": {
            taskCode: "share",
            title: "邀请好友参与游戏",
            content: "每邀请1个好友，游戏次数+1",
            tip: "每日加次数上限为10次",
            url: "https://b.pingan.com.cn/mkt/koudai/koudaijin/index.html?Source=dxqrw&outersource=yqs_201908&channel_source=1",
        },
        "bindCard":
        {
            taskCode: "bindCard",
            title: "绑定快捷支付",
            content: "完成任务得精美奖品",
            tip: "完成后1.15-1.30可领取",
            name: "快捷支付",
            url: "MB100018",
        },
        "mobilePay": {
            taskCode: "mobilePay",
            title: "签约手机号转账",
            content: "完成任务得精美奖品",
            tip: "完成后1.15-1.30可领取",
            name: "转账菜单",
            url: "00010301",
        }
    }

    export const guide: {
        [key: number]: {
            mask: string,
            text: {
                str: string,
                offsetToMask: {
                    x: number,
                    y: number
                }
            },
            arrow: boolean
        }
    } = {
        0: {
            mask: "guide_mask_0_png",
            text: {
                str: "左右移动炮车进行射击和躲避",
                offsetToMask: {
                    x: -34,
                    y: 270
                }
            },
            arrow: true
        },
        1: {
            mask: "guide_mask_1_png",
            text: {
                str: "拾取金币可获得更多的炮弹输出和得分加成",
                offsetToMask: {
                    x: -55,
                    y: 394
                }
            },
            arrow: false
        },
    }

    export const difficultyFactor = 0.25;
    export const rewardRecordUrl = "http://activity.m.duibatest.com.cn/projectx/p98a3fa4c/f09ba186f.html";

    export const rule = "";

}