declare namespace wx {
    /**注入权限验证配置 */
    function config(obj: {
        /**开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。 */
        debug: boolean,
        /**必填，公众号的唯一标识 */
        appId: string,
        /** 必填，生成签名的时间戳 */
        timestamp: string,
        /**必填，生成签名的随机串 */
        nonceStr: string,
        /**必填，签名 */
        signature: string,
        /**必填，需要使用的JS接口列表 */
        jsApiList: string[]
    }): void;

    /**
     * 处理成功验证
     * @param callback ready函数
     * @summary config信息验证后会执行ready方法，所有接口调用都必须在config接口获得结果之后
     * config是一个客户端的异步操作，所以如果需要在页面加载时就调用相关接口，则须把相关接口放在ready函数中调用来确保正确执行。
     * 对于用户触发时才调用的接口，则可以直接调用，不需要放在ready函数中。
     */
    function ready(callback: () => void): void;

    /**
     * 注册错误回调函数
     */
    function error(callback: (res: any) => void): void;

    /**
     * 获取地理位置
     */
    function getLocation(obj: {
        /**默认为wgs84的gps坐标，如果要返回直接给openLocation用的火星坐标，可传入'gcj02' */
        type: 'wgs84' | 'gcj02',
        success: (res: {
            /**纬度，浮点数，范围为90 ~ -90 */
            latitude: number,
            /**经度，浮点数，范围为180 ~ -180。 */
            longitude: number,
            /**速度，以米/每秒计 */
            speed: number,
            /**位置精度 */
            accuracy: number
        }) => void;
    } & Object): void;

    /**
     * 获取“分享到朋友圈”按钮点击状态及自定义分享内容
     */
    function onMenuShareTimeline(obj: ShareObject): void;


    /**
     * 获取“分享给朋友”按钮点击状态及自定义分享内容
     */
    function onMenuShareAppMessage(obj: {
        type?: string, // 分享类型,music、video或link，不填默认为link
        dataUrl?: string, // 如果type是music或video，则要提供数据链接，默认为空
    } & ShareObject): void;
}

interface ShareObject extends Object {
    /**分享标题 */
    title: string, // 
    /**分享描述 */
    desc: string,
    /**分享链接，该链接域名或路径必须与当前页面对应的公众号JS安全域名一致 */
    link: string,
    /**分享图标 */
    imgUrl: string,
}

interface Object {
    /**成功回调函数 */
    success: Function,
    /**失败回调函数 */
    fail?: Function,
    /**完成回调函数 无论成功会失败都会调用 */
    complete?: Function,
    /**取消回调函数 部分wx接口有 */
    cancel?: Function,
    trigger?: Function
}