class MLabel extends eui.Label implements eui.UIComponent {
    limit: number = 999;
    public set text(v: string) {
        if (typeof v == "undefined") return;
        v = v.toString();
        if (typeof v == "undefined") return;

        if (typeof this.limit == "number" && typeof v == "string" && this.getRealLength(v) > this.limit) {
            v = this.cutString(v, this.limit) + "...";
        }
        super.$setText(v);
    }

    private getRealLength(str: string) {
        var realLength = 0, len = str.length, charCode = -1;
        for (var i = 0; i < len; i++) {
            charCode = str.charCodeAt(i);
            if (charCode >= 0 && charCode <= 128) realLength += 1;
            else realLength += 2;
        }
        return realLength;
    }

    private cutString(str: string, realLength: number) {
        let length = 0;
        let out = "";
        for (let i of str) {
            let charCode = i.charCodeAt(0);
            if (charCode >= 0 && charCode <= 128) length += 1;
            else length += 2;

            if (length <= realLength)
                out = out.concat(i);
            if (length >= realLength)
                break;
        }
        return out;
    }
}
export default MLabel;