import { Decorator } from "../Decorator/Decorator";
import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { MConfigs } from "../Global/MConfigs";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene from "../Scene/StartScene";
import MBuried from "../Global/MBuried";

interface DataType {
    score: number,
    topScore: number,
    rewardUrl: string,
    rewardName: string
}

@Decorator.ClassName("GameOverPanel")
export default class GameOverPanel extends Panel {
    public btnClose: MButton;
    public labelScore: eui.Label;
    public labelTopScore: eui.Label;
    public btnRestart: MButton;
    /**替换为更多精彩按钮 */
    public btnUseProps: MButton;
    public imgReward: eui.Image;
    public labelReward: eui.Label;

    data: DataType;

    // private context: MainScene;

    private timestamp: number = null;

    constructor() {
        super();
        this.timestamp = egret.getTimer();
    }

    init(data: DataType) {
        this.data = data;
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.onClose();
        });

        MBuried.doShowBuried(3);
        this.labelScore.text = this.data.score.toString();
        this.labelTopScore.text = this.data.topScore.toString()
        this.labelReward.text = this.data.rewardName;
        this.imgReward.source = this.data.rewardUrl;

        MBuried.doShowBuried(4);
        this.btnRestart.onTap(this, () => {
            MBuried.doClickBuried(4);
            this.onClose();
        });

        MBuried.doShowBuried(5);
        this.btnUseProps.onTap(this, () => {
            MBuried.doClickBuried(5);
            location.href = MConfigs.urlMore;
        });
    }

    private onClose() {
        this.hidePanel();
        SceneCtrl.instance.change(StartScene);
    }
}